package Model::Emails;

use common::sense;

use Class::XSAccessor {
    constructor => 'new',
    accessors   => [qw/list/],
};

sub add {
    my $self = shift;
    my $email = shift;

    my $address = lc $email->address;

    return $self if $self->find($address);

    $self->{_emails_by_address}{$address} = $email;
    push @{ $self->{list} }, $email;

    return $self;
}

sub native {
    my $self = shift;

    my @result = grep { $_->is_native } @{ $self->list };

    return \@result;
}

sub default_native {
    my $self = shift;

    my @result = grep { $_->is_native and $_->is_default } @{ $self->list };

    return unless @result;
    return $result[0];
}

sub external {
    my $self = shift;

    my @result = grep { not $_->is_native } @{ $self->list };

    return \@result;
}

sub find {
    my $self = shift;
    my $address = lc shift;

    my $email = $self->{_emails_by_address}{$address} || undef;
    return unless $email;
    return $email;
}

sub main_external {
    my $self = shift;

    my @external = sort { $a->address cmp $b->address } @{ $self->external };
    my @sorted   = sort { $b->is_confirmed cmp $a->is_confirmed } @external;

    my $result = $sorted[0];

    return $result;
}

sub sorted {
    my $self = shift;

    my $external = $self->external;
    my $native   = $self->native;

    my $result = [
        sort({ $a->address cmp $b->address } @$external),
        sort({ $b->is_default <=> $a->is_default or $a->address cmp $b->address } @$native),
    ];

    return $result;
}

1;
