package Model::Hint;

use common::sense;

use Class::XSAccessor {
    constructor => 'new',
    accessors   => [qw/question answer/],
};

sub is_specified {
    my $self = shift;

    return $self->question->is_specified && $self->answer->is_specified ? 1 : 0;
}

sub dump {
    my $self = shift;

    return {
        question_id => $self->question->id,
        question    => $self->question->text,
        answer      => $self->answer->text,
    };
}

1;
