package Model::Karma;

use common::sense;

use Class::XSAccessor {
    constructor => 'new',
    accessors   => [qw/prefix suffix activation_datetime/],
};

sub value {
    my $self = shift;

    unless (@_) {
        my $result = $self->prefix * 1000 + $self->suffix;
        return $result;
    }

    my $value = shift;
    my $prefix = int($value / 1000);
    my $suffix = $value % 1000;

    $self->prefix($prefix);
    $self->suffix($suffix);

    return $self;
}

sub is_good {
    my $self = shift;

    my $result = ($self->value == 0 or $self->prefix == 2 or $self->prefix == 6) ? 1 : 0;

    return $result;
}

sub is_bad { shift->is_good ? 0 : 1 }

1;
