package Model::Person;

use common::sense;

use Class::XSAccessor {
    constructor => 'new',
    accessors   => [qw/firstname lastname sex birthday country city timezone language/],
};

sub name {
    my $self = shift;

    return '' unless length $self->lastname and length $self->firstname;
    return join '  ', $self->lastname, $self->firstname;
}

sub reverse_name {
    my $self = shift;

    return '' unless length $self->lastname and length $self->firstname;
    return join ' ', $self->firstname, $self->lastname;
}

1;
