package Model::Phones;

use common::sense;

use Class::XSAccessor {
    constructor => 'new',
    accessors   => [qw/list/],
};

sub add {
    my $self = shift;
    my $phone = shift;

    push @{ $self->{list} }, $phone;
    $self->{_phones_by_number}{ $phone->number } = $phone;

    return $self;
}

sub get_by_number {
    my $self = shift;
    my $number = shift;

    my $phone = $self->{_phones_by_number}{$number} || undef;

    return unless $phone;
    return $phone;
}

sub get_latest {
    my $self = shift;

    my $list    = $self->{list};
    my @ordered = sort { $b->confirmation_ts <=> $a->confirmation_ts } @$list;

    return $ordered[0];
}

sub is_latest {
    my $self = shift;
    my $phone = shift;

    my $latest_phone = $self->get_latest;
    my $result       = $latest_phone == $phone ? 1 : 0;

    return $result;
}

sub confirmed {
    my $self = shift;

    my @result = grep { $_->is_confirmed } @{ $self->{list} };

    return \@result;
}

sub unconfirmed {
    my $self = shift;

    my @result = grep { not $_->is_confirmed } @{ $self->{list} };

    return \@result;
}

1;
