package Model::Question;

use common::sense;

use Class::XSAccessor {
    constructor => 'new',
    accessors   => [qw/id text/],
};

sub serialized {
    my $self = shift;

    unless (@_) {
        return ''
          unless $self->id and length $self->text;
        my $value = join ':', $self->id, $self->text;
        return $value;
    }

    my $value = shift;
    my ($id, $text) = split /:/, $value, 2;
    $id = 0
      unless (1 <= $id and $id <= 19) or $id == 99;

    $self->id($id);
    $self->text($text || '');

    return $self;
}

sub is_user_defined { shift->id == 99 ? 1 : 0 }
sub is_predefined   { shift->id == 99 ? 0 : 1 }

sub is_specified {
    my $self = shift;

    return 0 unless $self->id;
    return 0 if $self->is_user_defined and not length $self->text;
    return 1;
}

1;
