package Model::Restoration;

use common::sense;

use Class::XSAccessor {
    constructor => 'new',
    accessors   => [qw/hint emails phones/],
};

my @RESTORATION_METHODS = qw/code email hint key phone/;
my %RESTORATION_METHODS = map { $_ => 1 } @RESTORATION_METHODS;

sub compose_methods {
    my $self = shift;

    $self->add_method('email') if $self->restorable_emails_number;
    $self->add_method('phone') if $self->restorable_phones_number;
    $self->add_method('hint')  if $self->hint->is_specified;

    return;
}

sub add_method {
    my $self   = shift;
    my $method = lc shift;
 
    die 'unknown method'
      unless exists $RESTORATION_METHODS{$method};

    $self->{methods}{$method} = 1;

    return;
}

sub delete_method {
    my $self   = shift;
    my $method = lc shift;
 
    die 'unknown method'
      unless exists $RESTORATION_METHODS{$method};

    delete $self->{methods}{$method};

    return;
}

sub is_method_available {
    my $self   = shift;
    my $method = lc shift;
 
    die 'unknown method'
      unless exists $RESTORATION_METHODS{$method};

    return exists $self->{methods}{$method} ? 1 : 0;
}

sub dump_methods { +{ %{ shift->{methods} } } }

sub methods_number {
    my $self = shift;

    my %methods = %{ $self->{methods} };

    my $result = scalar keys %methods;

    return $result;
}

sub restorable_emails_number { scalar shift->restorable_emails }
sub restorable_phones_number { scalar shift->restorable_phones }

sub restorable_emails {
    my $self = shift;

    my @result = grep { $self->is_restorable_email($_) } @{ $self->emails->list };

    return @result;
}

sub restorable_phones {
    my $self = shift;

    my @result = grep { $self->is_restorable_phone($_) } @{ $self->phones->list };

    return @result;
}

sub is_restorable_email {
    my $self = shift;
    my $email = shift;

    return 0 if $email->is_rpop;
    return 0 if $email->is_unsafe;
    return 0 if $email->is_native;
    return 0 if ! $email->is_confirmed;
    return 1;
}

sub is_restorable_phone {
    my $self = shift;
    my $phone = shift;

    return 0
      unless $phone->is_confirmed;

    my $result
      = $self->is_new_scheme_phone($phone)
      ? $phone->is_secure
      : 1;

    return $result;
}

sub is_new_scheme_phone {
    my $self = shift;
    my $phone = shift;

    my $phones_new_scheme_datetime = $main::Conf->GetVal('phones_new_scheme_datetime');
    my $phones_new_scheme_ts = Global::DatetimeToTimestamp($phones_new_scheme_datetime);
    my $result = $phone->confirmation_ts >= $phones_new_scheme_ts ? 1 : 0;

    return $result;
}

sub is_old_scheme_phone { $_[0]->is_new_scheme_phone($_[1]) ? 0 : 1 }

sub has_restorable_email {
    my $self = shift;
    my $address = shift;

    my $email = $self->emails->find($address);

    return 0 unless $email;
    return $self->is_restorable_email($email);
}

1;
