package Model::Subscription;

use common::sense;

use Class::XSAccessor {
    constructor => 'new',
    accessors   => [qw/suid sid login login_rule host_id host_number db_id/],
};

sub is_exists {
    my $self = shift;

    if ($self->sid == 16) {
        return 1 if $self->login;
    }
    else {
        return 1 if $self->suid;
        return 1 if defined $self->login_rule and $self->login_rule =~ /^\d+$/;
        return 1 if $self->login;
        return 1 if $self->host_id;
    }

    return 0;
}

1;
