package Model::Subscriptions;

use common::sense;

use Class::XSAccessor {
    constructor => 'new',
};

sub add {
    my $self = shift;
    my ($subscription) = @_;

    $self->{by_sid}{$subscription->sid} = $subscription;

    return $self;
}

sub get {
    my $self = shift;
    my ($sid) = @_;

    my $result = $self->{by_sid}{$sid} ||= Model::Subscription->new(sid => $sid);

    return $result;
}

sub list {
    my $self = shift;

    my @result = values %{ $self->{by_sid} };
    @result = grep { $_->is_exists } @result;

    return \@result;
}

1;
