package Passport;

use strict;
use utf8;
use open qw/:std :utf8/;

use Authorization;
use Database::Collection;
use Database::Connection;
use Database::Group;

sub CreateAuthorization {
    my $dbaf = shift;

    my $conf = $main::Conf;
    my @authz_config = (
        dbaf    => $dbaf,
        params  => $Input::AllVals,
        cookies => $Input::Cookie,
        input   => $Input::Input,

        passport_host  => $conf->GetVal('this_host_id'),
        current_domain => $conf->GetVal('root_cookie'),

        is_pdd_mode_code_ref => \&Global::DMMode,
    );

    return Authorization->new(@authz_config);
}

sub _add_credentials {
    my $db_conf = shift;
    my $db_name = shift;

    my $db_credentials = $main::Conf->GetVal('db_credentials');
    die "No db_credentials in config" unless defined $db_credentials;

    my $profile_name = $db_conf->{profile};
    unless (exists $db_credentials->{$profile_name}) {
        die "No db profile for connection $db_name ".Dumper($db_conf);
    }
    my $profile = $db_credentials->{$profile_name};
    $db_conf->{user} = $profile->{user};
    $db_conf->{pass} = $profile->{pass};
}

sub db_init_uid_collection {
    my $slave_name = shift || 'sharddbslave';

    my $masters_conf = $main::Conf->GetVal('sharddbmaster');
    my $slaves_conf  = $main::Conf->GetVal($slave_name);

    my $ranges  = $main::Conf->GetVal('uid_collection_ranges');

    return unless $ranges;

    my $cutoffs = $ranges->{cutoffs};
    my $shards  = $ranges->{shards};

    my @groups;
    my %group_by_shard_id;

    while (my ($shard_id, $master_conf) = each %$masters_conf) {
        my %args;

        _add_credentials($master_conf, 'sharddbmaster:shard'.$shard_id);
        $args{master} = Database::Connection->new(%$master_conf);
        if (my $slave_conf = $slaves_conf->{$shard_id}) {
            _add_credentials($slave_conf, $slave_name.':shard'.$shard_id);
            $args{slave} = Database::Connection->new(%$slave_conf);
        }
        $args{name} = $master_conf->{group_name};

        my $group = Database::Group->new(%args);

        push @groups, $group;
        $group_by_shard_id{$shard_id} = $group;
    }

    my $collection = Database::Collection->new(name => 'uid', groups => \@groups);

    my $shard_id_chooser = sub {
        my $uid = shift;
        my $index = Global::BinarySearch($uid, $cutoffs);
        die "uid $uid isn't found in cutoffs"
          unless defined $index;
        my $shard = $shards->[$index];
        die "uid $uid isn't mapped to any shard"
          unless defined $shard;
        return $shard;
    };

    my $group_chooser = sub {
        my $shard = shift;
        my $group = $group_by_shard_id{$shard};
        die "shard $shard isn't mapped to any group"
          unless $group;
        return $group;
    };

    $collection->shard_id_chooser($shard_id_chooser);
    $collection->group_chooser($group_chooser);

    return $collection;
}

sub db_init_central_group {
    my $slave_name = shift || 'centraldbslave';

    my %master_conf = get_connection_args_for_old_db('centraldbmaster');
    my %slave_conf  = get_connection_args_for_old_db($slave_name);

    my %args;
    _add_credentials(\%master_conf, 'centraldbmaster');
    _add_credentials(\%slave_conf, $slave_name);
    $args{master} = Database::Connection->new(%master_conf);
    $args{slave}  = Database::Connection->new(%slave_conf)
      if %slave_conf;

    my $group = Database::Group->new(%args);

    return $group;
}

sub get_connection_args_for_old_db {
    my $name = shift;
    my $conf = $main::Conf->GetVal($name);
    return unless $conf;
    return (
        dsn  => $conf->{src},
        profile => $conf->{profile},
    );
}

1;
