package Utils;

use common::sense;

sub get_host {
    my $class = shift;
    my %args = @_;

    die "hosts is required"
      unless $args{hosts};

    my $hosts = do $args{hosts};

    die "can't load hosts configuration: ", $@ || $!, "\n"
      unless $hosts;

    my %bykey;
    for my $host (@$hosts) {
        for my $key (@{ $host->{keys} }) {
            push @{ $bykey{$key} }, $host;
        }
    }

    my $key   = $args{host} || `hostname -f`;
    chomp $key;
    my $found = $bykey{$key};

    if (!@$found) {
        my $known_hosts = join("\n", keys %bykey);
        die "unknown host '$key'. Known hosts:\n$known_hosts\n."
    }

    die "several hosts '$key' has been found, you must choose the only one\n"
      if @$found > 1;

    my $host = $found->[0];

    return $host;
}

1;
