package AdminScriptsEnvironment;

use DBAF;
use Passport;

use base 'Exporter';

my @FUNCTIONS = qw/load_dbaf load_config get_dbh logit logerror/;

our @EXPORT_OK   = @FUNCTIONS;
our %EXPORT_TAGS = (all => [@FUNCTIONS]);

sub load_config {
    my ($admpath, $path) = @_;

    die "config path '$admpath' isn't exists"
      unless $admpath and -d $admpath;

    die "config path '$path' isn't exists"
      unless $path and -d $path;

    $httpdconf::admetcpath = $admpath;
    $httpdconf::etcpath    = $path;
    $main::etcpath         = $path;

    my ($admconfig, $config);
    {
        local *STDERR;
        open STDERR, '>', '/dev/null';
        require ADM::Conf;
        $admconfig = ADM::Conf->new($admpath);
        require Conf;
        $config = Conf->new;
    }

    die "can't load config '$admpath'"
      unless $admconfig;

    die "can't load config '$path'"
      unless $config;

    $admin::Conf = $admconfig;
    $main::Conf  = $config;

    use Log::Any::Adapter;
    Log::Any::Adapter->set('+LogAnyAdapter');

    return ($admconfig, $config);
}

sub load_dbaf {
    my $dbaf = DBAF->instance;
    unless ($dbaf) {
        $dbaf = DBAF->NewDBAF;
        $dbaf->NewSAFE;
        $dbaf->uid_collection(Passport::db_init_uid_collection('admsharddbslave'));
        $dbaf->central_group(Passport::db_init_central_group('admcentraldbslave'));
        $dbaf = DBAF->instance;
    }

    return $dbaf;
}

sub get_dbh {
    my $name = shift;

    my $conf = $main::Conf->GetVal($name);

    my $dbh = DBI->connect($conf->{src}, $conf->{user}, $conf->{passwd}, { RaiseError => 1, PrintError => 0 });
    $dbh->{mysql_enable_utf8} = 1;
    $dbh->do('SET NAMES utf8');

    return $dbh;
}

sub logit (@) {
    my ($sec, $min, $hour, $day, $mon, $year) = localtime;
    my $now = sprintf '%04d-%02d-%02d %02d:%02d:%02d', $year + 1900, $mon + 1, $day, $hour, $min, $sec;

    print "[$now] ", join('', @_), "\n";
}

sub logerror (@) {
    my ($sec, $min, $hour, $day, $mon, $year) = localtime;
    my $now = sprintf '%04d-%02d-%02d %02d:%02d:%02d', $year + 1900, $mon + 1, $day, $hour, $min, $sec;

    print STDERR "[$now] ", join('', @_), "\n";
}

1;
