#!/usr/bin/env perl

use lib::abs '../admin/lib';

use common::sense;

use Crypt::NaCl::Sodium ':utils'; # https://github.com/jedisct1/libsodium/
use Digest::SHA 'sha256';
use JSON;
use MIME::Base32 'RFC';
use MIME::Base64 'encode_base64url';

use ADM::SodiumSeal;

my $algorithm_version    = 2;
my $diagnostic_version   = 1;
my $uid                  = 4000332957;
my $login                = 'spleenjackFA ';
my $attribute            = '2:1:1:AdWUPIzs3dTmZ+bNruaL/Q==:gxPrwCwfb0iOLsM8e5EXTwUoh9yUtQwEE1Tm8ZvmoqY=:X0MfYjw6hgAygo6KXVdJLLWS1YQIElMejGdxWuS6QBM=';
my $secret_b32           = 'AVED VTKJ O5R4 ZLPC 6XE5 JTV6';
my $pin_int              = 1122;
my $offset               = -3 * 3600;
my $correction           = +3 * 3600 - 1;
my $ts                   = 1434983880;
my $is_magic             = \1;
my $from_account_manager = \1;
my $is_manual_init       = \1;
my $is_touch_id          = \1;
my $totp_str             = 'onvvsffj'; # ./gentotp 8 zlV48wXHqmtIcaEcCMviQg== 1434983880 Letters
my $secret_salt_str      = 'saltsaltsaltsal1';
my $pin_secret_salt_str  = 'saltsaltsaltsal2';
my $totp_salt_str        = 'saltsaltsaltsal3';
my $login_salt_str       = 'saltsaltsaltsal4';
my $uid_salt_str         = 'saltsaltsaltsal5';
my $public_key_hex       = '45f044b15d707104c675dc0be11c6b15050e4a5ebe226853dcbc159edc46e913';
my $private_key_hex      = 'a9d230097589d2befee13abff8e7128e1edb78b4deaa1c316a32278e6033fc78';



sub str2hex ($) { unpack 'H*', $_[0] }
sub hex2str ($) {   pack 'H*', $_[0] }
sub str2b64 ($) { encode_base64url $_[0], '' }

sub normalize_login {
    my $login = shift;

    $login = lc $login;
    $login =~ s/^\s+//g;
    $login =~ s/\s+$//g;
    $login =~ s/\./-/g
      if not $login =~ /\@/;

    return $login;
}



my $crypto_box         = Crypt::NaCl::Sodium->box;
#my $crypto_shorthash   = Crypt::NaCl::Sodium->shorthash;



my $public_key_str     = hex2str $public_key_hex;
my $private_key_str    = hex2str $private_key_hex;

# ($public_key_str, $private_key_str) = $crypto_box->keypair;
# $secret_key_str                     = $crypto_shorthash->keygen;
# $pin_secret_key_str                 = $crypto_shorthash->keygen;
# $totp_key_str                       = $crypto_shorthash->keygen;
# $login_key_str                      = $crypto_shorthash->keygen;

my $normalized_login   = normalize_login($login);
$secret_b32            =~ s/ //g;
my $secret_str         = MIME::Base32::decode($secret_b32);
say str2hex $secret_str;
my $pin_str            = sprintf '%04d', $pin_int;

#my $secret_id_str      = $crypto_shorthash->mac($secret_str,            $secret_key_str);
#my $pin_secret_id_str  = $crypto_shorthash->mac($pin_str . $secret_str, $pin_secret_key_str);
#my $totp_id_str        = $crypto_shorthash->mac($totp_str,              $totp_key_str);
#my $login_id_str       = $crypto_shorthash->mac($normalized_login,      $login_key_str);
#my $uid_id_str         = $crypto_shorthash->mac($uid,                   $uid_key_str);

#my $secret_id_b64      = str2b64 $secret_id_str;      # ZHxKWJRpcks
#my $pin_secret_id_b64  = str2b64 $pin_secret_id_str;  # tNdeOGxXQQY
#my $totp_id_b64        = str2b64 $totp_id_str;        # _i661tTik4k
#my $login_id_b64       = str2b64 $login_id_str;       # ou12iRn3iDE
#my $uid_id_b64         = str2b64 $uid_id_str;         # wtSxiEMPqBE

my $secret_salt_b64     = str2b64 $secret_salt_str;     # c2FsdHNhbHRzYWx0c2FsMQ
my $pin_secret_salt_b64 = str2b64 $pin_secret_salt_str; # c2FsdHNhbHRzYWx0c2FsMg
my $totp_salt_b64       = str2b64 $totp_salt_str;       # c2FsdHNhbHRzYWx0c2FsMw
my $login_salt_b64      = str2b64 $login_salt_str;      # c2FsdHNhbHRzYWx0c2FsNA
my $uid_salt_b64        = str2b64 $uid_salt_str;        # c2FsdHNhbHRzYWx0c2FsNQ

my $secret_id_str       = sha256 $secret_salt_str     . $secret_str;
my $pin_secret_id_str   = sha256 $pin_secret_salt_str . $pin_str . $secret_str;
my $totp_id_str         = sha256 $totp_salt_str       . $totp_str;
my $login_id_str        = sha256 $login_salt_str      . $normalized_login;
my $uid_id_str          = sha256 $uid_salt_str        . $uid;

my $secret_id_b64       = str2b64 $secret_id_str;      # Fw1S90_M5PxK8drSC33r0WJb18BG98g2pCzMRX8NXWo
my $pin_secret_id_b64   = str2b64 $pin_secret_id_str;  # 1bkXREYFXWNx7zRtJfyztBmkpbtQwtiEI7MxqvunsWw
my $totp_id_b64         = str2b64 $totp_id_str;        # nRHn2dlLLtfskgw6cSuI8Sr9sEEOYOA2GOJcPwmIZ_Y
my $login_id_b64        = str2b64 $login_id_str;       # 8ZG93loOU3kZPgZWZphbhgQRnYdJFyjdHgvjZHWZAao
my $uid_id_b64          = str2b64 $uid_id_str;         # 4vkyfsc33oCFoQkMmbyybH93ii1VvyR-UrAKt5ewV3I



my $diagnostic = {
    diag => {
        av   => $algorithm_version,
        dv   => $diagnostic_version,

        ts   => $ts,
        crr  => $correction,

        sk   => $secret_salt_b64,
        sid  => $secret_id_b64,

        psk  => $pin_secret_salt_b64,
        psid => $pin_secret_id_b64,

        tk   => $totp_salt_b64,
        tid  => $totp_id_b64,

        lk   => $login_salt_b64,
        lid  => $login_id_b64,

        uk   => $uid_salt_b64,
        uid  => $uid_id_b64,

        mgc  => $is_magic,
        am   => $from_account_manager,
        mnl  => $is_manual_init,
        tch  => $is_touch_id,
    },

    device => {
        tz => 'Europe/Moscow', # тут будут ещё какие-то данные по девайсу
    },

    app => {
        version => '1.02', # тут данные по самому приложению
    },
};



my $json_encoder = JSON->new->canonical(1);

my $json_pretty  = $json_encoder->pretty(1)->encode($diagnostic);
my $json_compact = $json_encoder->pretty(0)->encode($diagnostic);

my $sealed_str = ADM::SodiumSeal::crypto_box_seal($json_compact, $public_key_str);
my $sealed_hex = str2hex $sealed_str;
my $sealed_b64 = str2b64 $sealed_str;

my $opened_str = ADM::SodiumSeal::crypto_box_seal_open($sealed_str, $public_key_str, $private_key_str);

say "public key:  ", str2hex $public_key_str;
say "private key: ", str2hex $private_key_str;
say "";
say $json_pretty;
say $json_compact, "\n";
say "sealed_hex:\n", $sealed_hex, "\n";
say "sealed_b64:\n", $sealed_b64, "\n";
say "opened:\n", $opened_str, "\n";




=pod
my $secret_hex          = str2hex $secret_str;                      # 05483acd497763ccade2f5c9d4cebe
my $secret_with_pin_hex;
{
    use bigint;
    my $secret_with_pin_int = hex($secret_hex) * 10_000 + $pin_int; # 274264765508052865401828126367945581122
    $secret_with_pin_hex = substr $secret_with_pin_int->as_hex, 2;  # ce5578f305c7aa6b4871a11c08cbe242
}
my $secret_with_pin_str = hex2str $secret_with_pin_hex;
my $secret_with_pin_b64 = str2b64 $secret_with_pin_str;             # zlV48wXHqmtIcaEcCMviQg==
=cut

__DATA__
CPP:

pk: 45f044b15d707104c675dc0be11c6b15050e4a5ebe226853dcbc159edc46e913
sk: a9d230097589d2befee13abff8e7128e1edb78b4deaa1c316a32278e6033fc78

-> my_crypto_box_seal
epk: f18485ac094e46082e5fe520bd19cf20862bcccde38527acaa3f73d7f1e61479
esk: e5039c6088ed64fd1e8f029e0e435104ef7ecb8dba4d79453fb80cb94247a998
nonceg: 58e347846b692ecbc684b76a7004ce2dc2427dfc68e68559
--> my_crypto_box_detached
m: 4d657373616765
n: 58e347846b692ecbc684b76a7004ce2dc2427dfc68e68559
k: 508ba0a8d488601cc292b23db3697b869dff24c97bc56a3f8424d296f8096217
mac: f7ca5ee53a763e6b72a64df827285ad2
c: f18485ac094e46082e5fe520bd19cf20862bcccde38527acaa3f73d7f1e61479f7ca5ee53a763e6b72a64df827285ad2201ce62112c5cc

-> my_crypto_box_seal_open
nonceg: 58e347846b692ecbc684b76a7004ce2dc2427dfc68e68559
decrypted: Message


PERL:

public_key: 45f044b15d707104c675dc0be11c6b15050e4a5ebe226853dcbc159edc46e913
private key: a9d230097589d2befee13abff8e7128e1edb78b4deaa1c316a32278e6033fc78
c3bdc7459b6ca6f5b23401e0e35856f851c18d2137beb1b7

-> crypto_box_seal
in: Message
pk: 45f044b15d707104c675dc0be11c6b15050e4a5ebe226853dcbc159edc46e913
epk: f18485ac094e46082e5fe520bd19cf20862bcccde38527acaa3f73d7f1e61479
esk: e5039c6088ed64fd1e8f029e0e435104ef7ecb8dba4d79453fb80cb94247a998
nonce : 58e347846b692ecbc684b76a7004ce2dc2427dfc68e68559
nonceg: 58e347846b692ecbc684b76a7004ce2dc2427dfc68e68559
--> crypto_box_detached
m: 4d657373616765
n: 58e347846b692ecbc684b76a7004ce2dc2427dfc68e68559
k: 508ba0a8d488601cc292b23db3697b869dff24c97bc56a3f8424d296f8096217
mac: f7ca5ee53a763e6b72a64df827285ad2
c: 201ce62112c5cc
out(epk+mac+c): f18485ac094e46082e5fe520bd19cf20862bcccde38527acaa3f73d7f1e61479f7ca5ee53a763e6b72a64df827285ad2201ce62112c5cc

-> crypto_box_seal_open
in: f18485ac094e46082e5fe520bd19cf20862bcccde38527acaa3f73d7f1e61479f7ca5ee53a763e6b72a64df827285ad2201ce62112c5cc
pk: 45f044b15d707104c675dc0be11c6b15050e4a5ebe226853dcbc159edc46e913
sk: a9d230097589d2befee13abff8e7128e1edb78b4deaa1c316a32278e6033fc78
epk: f18485ac094e46082e5fe520bd19cf20862bcccde38527acaa3f73d7f1e61479
nonce : 58e347846b692ecbc684b76a7004ce2dc2427dfc68e68559
nonceg: 58e347846b692ecbc684b76a7004ce2dc2427dfc68e68559
mac: f7ca5ee53a763e6b72a64df827285ad2
c: 201ce62112c5cc
k: 508ba0a8d488601cc292b23db3697b869dff24c97bc56a3f8424d296f8096217
m: 4d657373616765
m: Message

opened: 4d657373616765

