#!/usr/bin/env perl

use lib::abs '../admin/lib';

use common::sense;

use Crypt::NaCl::Sodium ':utils'; # https://github.com/jedisct1/libsodium/
use Digest::SHA 'sha256';
use Data::Dumper;
use JSON::XS;
use MIME::Base32 'RFC';
use MIME::Base64 qw/encode_base64url decode_base64url/;

use ADM::SodiumSeal;

my $public_key_hex       = '45f044b15d707104c675dc0be11c6b15050e4a5ebe226853dcbc159edc46e913';
my $private_key_hex      = 'a9d230097589d2befee13abff8e7128e1edb78b4deaa1c316a32278e6033fc78';

sub str2hex ($) { unpack 'H*', $_[0] }
sub hex2str ($) {   pack 'H*', $_[0] }
sub str2b64 ($) { encode_base64url $_[0], '' }
sub b642str ($) { decode_base64url $_[0] }

my $public_key_str  = hex2str $public_key_hex;
my $private_key_str = hex2str $private_key_hex;

my $sealed_b64 = <>;
my $sealed_str = b642str $sealed_b64;
my $sealed_hex = str2hex $sealed_str;
#say $sealed_hex;
#say "length: ", length $sealed_str;

my $opened_str = ADM::SodiumSeal::crypto_box_seal_open($sealed_str, $public_key_str, $private_key_str);
utf8::upgrade $opened_str;

#print $opened_str;

my $diagnostic = decode_json $opened_str;

print Dumper($diagnostic);

my $login                 = 'qwerty';
my $login_salt_str        = b642str $diagnostic->{diag}{lk};
my $login_id_b64          = $diagnostic->{diag}{lid};
my $expected_login_id_b64 = str2b64(sha256($login_salt_str . $login));
say $login_id_b64, " == ", $expected_login_id_b64;

