
DROP TABLE IF EXISTS countries;
CREATE TABLE countries (
  id bigint(20) NOT NULL default '0',
  country varchar(40) NOT NULL default '',
  code varchar(2) default NULL,
  PRIMARY KEY  (id),
  UNIQUE KEY country (country)
) TYPE=MyISAM;

DROP TABLE IF EXISTS doc_types;
CREATE TABLE doc_types (
  type tinyint(4) NOT NULL default '0',
  name varchar(60) NOT NULL default '',
  PRIMARY KEY  (type),
  UNIQUE KEY name (name)
) TYPE=MyISAM;

DROP TABLE IF EXISTS documents;
CREATE TABLE documents (
  uid bigint(20) NOT NULL default '0',
  version int(6) NOT NULL default '0',
  version_date datetime default NULL,
  doc_type tinyint(4) NOT NULL default '0',
  doc_type_other varchar(255) default NULL,
  validated tinyint(1) NOT NULL default '0',
  residence_country smallint default NULL,
  doc_number varchar(40) default NULL,
  issue_date date default NULL,
  issue_place varchar(255) default NULL,
  issue_agency varchar(255) default NULL,
  fio varchar(100) default NULL,
  PRIMARY KEY  (uid,version)
) TYPE=MyISAM;

