-- MySQL dump 10.11
--
-- Host: localhost    Database: safeguarddb
-- ------------------------------------------------------
-- Server version	5.0.51a-3ubuntu5.4

--
-- Table structure for table `domains_account_info`
--

DROP TABLE IF EXISTS domains_account_info;
CREATE TABLE domains_account_info (
  uid bigint(20) NOT NULL auto_increment,
  `fio` varchar(50) character set utf8 default NULL,
  sex tinyint(4) default NULL,
  birth_date date default '0000-00-00',
  country varchar(20) default NULL,
  `region` varchar(20) character set utf8 default NULL,
  city varchar(40) default NULL,
  `charset` varchar(30) default NULL,
  mail_format varchar(10) default NULL,
  email varchar(80) NOT NULL default '',
  `nickname` varchar(40) character set utf8 default NULL,
  whatis varchar(40) default NULL,
  reg_date datetime default NULL,
  address varchar(50) default NULL,
  job varchar(40) default NULL,
  tz varchar(40) NOT NULL default 'Europe/Moscow',
  `firstname` varchar(50) character set utf8 default NULL,
  `lastname` varchar(50) character set utf8 default NULL,
  PRIMARY KEY  (uid),
  KEY x2 (email)
) ENGINE=MyISAM AUTO_INCREMENT=1130000000000001 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS domains_userinfo;
CREATE TABLE domains_userinfo (
  uid bigint(20) NOT NULL,
  firstname varchar(50) collate utf8_unicode_ci default NULL,
  lastname varchar(50) collate utf8_unicode_ci default NULL,
  sex tinyint(4) default NULL,
  birth_date date default '0000-00-00',
  country varchar(20) collate utf8_unicode_ci default NULL,
  city varchar(50) collate utf8_unicode_ci default NULL,
  email varchar(80) collate utf8_unicode_ci NOT NULL default '',
  nickname varchar(40) collate utf8_unicode_ci default NULL,
  reg_date datetime default NULL,
  tz varchar(60) collate utf8_unicode_ci NOT NULL default 'Europe/Moscow',
  PRIMARY KEY  (uid)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

--
-- Table structure for table `domains_accounts`
--

DROP TABLE IF EXISTS domains_accounts;
CREATE TABLE domains_accounts (
  uid bigint(20) NOT NULL auto_increment,
  login varchar(40) NOT NULL default '',
  passwd varchar(40) NOT NULL default '',
  ena tinyint(1) NOT NULL default '0',
  acl_id bigint(20) NOT NULL default '0',
  karma smallint(6) NOT NULL default '0',
  glogout bigint(20) NOT NULL default '1',
  domid int(10) NOT NULL default '0',
  PRIMARY KEY  (uid),
  UNIQUE KEY user_dom (login,domid),
  KEY dom_index (domid)
) ENGINE=MyISAM AUTO_INCREMENT=1130000000000001 DEFAULT CHARSET=latin1;

--
-- Table structure for table `domains_badauth_ip`
--

DROP TABLE IF EXISTS domains_badauth_ip;
CREATE TABLE domains_badauth_ip (
  ip varchar(16) NOT NULL default '',
  create_time datetime NOT NULL default '0000-00-00 00:00:00',
  KEY ip (ip),
  KEY `create_time` (`create_time`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `domains_badauth_login`
--

DROP TABLE IF EXISTS domains_badauth_login;
CREATE TABLE domains_badauth_login (
  login varchar(80) NOT NULL default '',
  create_time datetime NOT NULL default '0000-00-00 00:00:00',
  KEY login (login),
  KEY `create_time` (`create_time`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `domains_hosts`
--

DROP TABLE IF EXISTS domains_hosts;
CREATE TABLE domains_hosts (
  host_id int(11) NOT NULL auto_increment,
  host_ip varchar(16) default NULL,
  host_name varchar(255) default NULL,
  db_id varchar(40) default NULL,
  sid smallint(5) NOT NULL default '0',
  prio int(11) NOT NULL default '0',
  host_number bigint(20) NOT NULL default '0',
  mx varchar(30) default NULL,
  PRIMARY KEY  (host_id)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

--
-- Table structure for table `domains_subscription`
--

DROP TABLE IF EXISTS domains_subscription;
CREATE TABLE domains_subscription (
  suid bigint(20) NOT NULL auto_increment,
  sid smallint(5) NOT NULL default '0',
  uid bigint(20) NOT NULL default '0',
  login varchar(121) NOT NULL default '',
  host_id int(11) default NULL,
  login_rule smallint(5) NOT NULL default '1',
  born_date datetime default NULL,
  PRIMARY KEY  (suid,sid),
  UNIQUE KEY lg (login,sid),
  KEY x1 (uid)
) ENGINE=MyISAM AUTO_INCREMENT=1130000000000001 DEFAULT CHARSET=latin1;

--
-- Table structure for table `domains_yamail_info`
--

DROP TABLE IF EXISTS domains_yamail_info;
CREATE TABLE domains_yamail_info (
  suid bigint(20) NOT NULL default '0',
  mail_limit bigint(20) NOT NULL default '0',
  nickname varchar(50) default NULL,
  PRIMARY KEY  (suid)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


--
-- Table structure for table `hosted_domains`
--

DROP TABLE IF EXISTS hosted_domains;
CREATE TABLE hosted_domains (
  domid int(20) NOT NULL auto_increment,
  domain varchar(80) NOT NULL default '',
  admin bigint(20) NOT NULL default '0',
  mx tinyint(4) NOT NULL default '0',
  ena tinyint(1) NOT NULL default '0',
  born_date datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (domid),
  UNIQUE KEY dom (domain),
  KEY adm (admin)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

--
-- Table structure for table `domains_events`
--

DROP TABLE IF EXISTS domains_events;
CREATE TABLE domains_events (
  id int(11) NOT NULL auto_increment,
  type tinyint(4) NOT NULL,
  domain varchar(80) NOT NULL default '',
  created timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY (id)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- Dump completed on 2009-04-22  9:38:35
