-- safeguarddb

SET NAMES binary;
DROP VIEW IF EXISTS account_info;
CREATE ALGORITHM=MERGE VIEW account_info (
  uid, fio, sex,
  birth_date, country, region, city,
  charset, mail_format, icq, email, nickname,
  whatis, reg_date, homepage, address, company, tel, fax,
  age, job, user_picture, zip
) AS SELECT
  uid, CAST(CONVERT(CONCAT(lastname, '  ', firstname) USING cp1251) AS CHAR), sex,
  birth_date, country, NULL, CAST(CONVERT(city USING cp1251) AS CHAR),
  'windows-1251', 'plain', NULL, email, CAST(CONVERT(nickname USING cp1251) AS CHAR),
  NULL, reg_date, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
FROM userinfo;

-- sezam

SET NAMES binary;
DROP VIEW IF EXISTS account_safe;
CREATE ALGORITHM=MERGE VIEW account_safe (
  uid, hintq, hinta, cryptpasswd
) AS SELECT
  uid, CAST(CONVERT(hintq USING cp1251) AS CHAR), CAST(CONVERT(hinta USING cp1251) AS CHAR), cryptpasswd
FROM userinfo_safe;

SET NAMES binary;
DROP VIEW IF EXISTS account_ft;
CREATE ALGORITHM=MERGE VIEW account_ft (
  uid, fio, email,
  hintq, hinta,
  reg_date, ip_from, ip_prox
) AS SELECT
  uid, CAST(CONVERT(CONCAT(lastname, '  ', firstname) USING cp1251) AS CHAR), email,
  CAST(CONVERT(hintq USING cp1251) AS CHAR), CAST(CONVERT(hinta USING cp1251) AS CHAR),
  reg_date, ip_from, ip_prox
FROM userinfo_ft;

SET NAMES binary;
DROP VIEW IF EXISTS account_ft_login;
CREATE ALGORITHM=MERGE VIEW account_ft_login (
  uid, login
) AS SELECT
  uid, login
FROM userinfo_ft;

