--------------------------------------------------
--
-- central
--

CREATE TABLE uid (
  id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (id)
) ENGINE=InnoDB AUTO_INCREMENT=264000000;
-- 1120000000022000 - team

-- Не нужна в team
CREATE TABLE pdduid (
  id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (id)
) ENGINE=InnoDB AUTO_INCREMENT=1130000012800000;

CREATE TABLE suid (
  id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (id)
) ENGINE=InnoDB AUTO_INCREMENT=812000000;
-- 1120000000150000 - team

-- Не нужна в team
CREATE TABLE pddsuid (
  id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (id)
) ENGINE=InnoDB AUTO_INCREMENT=1130000030000000;
-- 1130000000200000 - test

CREATE TABLE phone_id (
  phone_id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (phone_id)
) ENGINE=InnoDB AUTO_INCREMENT=150000000;
-- 12000000 - test

CREATE TABLE email_id (
  email_id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (email_id)
) ENGINE=InnoDB AUTO_INCREMENT=334000000;
-- 215980000 - test

CREATE TABLE aliases (
  uid            BIGINT   UNSIGNED NOT NULL DEFAULT 0,
  type           SMALLINT UNSIGNED NOT NULL DEFAULT 0,
  value          VARBINARY(255)    NOT NULL DEFAULT '',
  surrogate_type VARBINARY(255)    NOT NULL DEFAULT '',
  PRIMARY KEY (uid, surrogate_type),
  UNIQUE KEY (type, value)
) ENGINE=InnoDB;

-- Рассматривали вариант с полем fake_value, в которое пишется значение поля value при type == 8 и пустая строка в остальных случаях,
-- при этом PK делается (uid, type, fake_value).  Получилось на 6% больше по объёму.

-- Не нужна в team
CREATE TABLE ranges (
  min    BIGINT  UNSIGNED NOT NULL DEFAULT 0,
  shard  TINYINT UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (min)
) ENGINE=InnoDB;

-- Не нужна в team
delimiter //
DROP PROCEDURE IF EXISTS shard//
CREATE PROCEDURE shard (IN uid BIGINT UNSIGNED)
BEGIN
    SELECT shard FROM ranges WHERE min <= uid ORDER BY min DESC LIMIT 1;
END//
delimiter ;


CREATE TABLE suid2 (
  suid BIGINT UNSIGNED NOT NULL DEFAULT 0,
  uid  BIGINT UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (suid),
  UNIQUE KEY (uid)
) ENGINE=InnoDB;

-- Не нужна в team (всё равно создана, т.к. требуется в method=loginoccupation)
CREATE TABLE reserved_logins (
  login   VARBINARY(255) NOT NULL DEFAULT '',
  free_ts TIMESTAMP      NOT NULL DEFAULT 0,
  PRIMARY KEY (login),
  KEY (free_ts)
) ENGINE=InnoDB;

CREATE TABLE removed_aliases (
  uid   BIGINT   UNSIGNED NOT NULL DEFAULT 0,
  type  SMALLINT UNSIGNED NOT NULL DEFAULT 0,
  value VARBINARY(255)    NOT NULL DEFAULT '',
  PRIMARY KEY (type, value, uid),
  KEY (uid)
) ENGINE=InnoDB;

CREATE TABLE domains_events (
  id        INT     UNSIGNED NOT NULL AUTO_INCREMENT,
  domain_id INT     UNSIGNED NOT NULL DEFAULT 0,
  type      TINYINT UNSIGNED NOT NULL DEFAULT 0,
  ts        TIMESTAMP        NOT NULL DEFAULT 0,
  PRIMARY KEY (id)
) ENGINE=InnoDB;

CREATE TABLE domains (
  domain_id        INT     UNSIGNED NOT NULL AUTO_INCREMENT,
  master_domain_id INT     UNSIGNED NOT NULL DEFAULT 0,
  name             VARBINARY(255)   NOT NULL DEFAULT '',
  enabled          TINYINT UNSIGNED NOT NULL DEFAULT 0,
  mx               TINYINT UNSIGNED NOT NULL DEFAULT 0,
  admin_uid        BIGINT  UNSIGNED NOT NULL DEFAULT 0,
  default_uid      BIGINT  UNSIGNED NOT NULL DEFAULT 0,
  ts               TIMESTAMP        NOT NULL DEFAULT 0,
  options          VARBINARY(255)   NOT NULL DEFAULT '',
  PRIMARY KEY (domain_id),
  UNIQUE KEY (name),
  KEY (admin_uid),
  KEY (master_domain_id)
) ENGINE=InnoDB;

CREATE TABLE hosts (
  host_id     SMALLINT UNSIGNED NOT NULL AUTO_INCREMENT,
  host_ip     VARCHAR(16)                DEFAULT NULL,
  host_name   VARCHAR(255)               DEFAULT NULL,
  db_id       VARCHAR(40)                DEFAULT NULL,
  sid         TINYINT  UNSIGNED NOT NULL DEFAULT 0,
  prio        SMALLINT          NOT NULL DEFAULT 0,
  host_number SMALLINT UNSIGNED NOT NULL DEFAULT 0,
  mx          VARCHAR(30)                DEFAULT NULL,
  PRIMARY KEY (host_id),
  KEY (db_id)
) ENGINE=InnoDB;

CREATE TABLE domains_hosts (
  host_id     SMALLINT UNSIGNED NOT NULL AUTO_INCREMENT,
  host_ip     VARCHAR(16)                DEFAULT NULL,
  host_name   VARCHAR(255)               DEFAULT NULL,
  db_id       VARCHAR(40)                DEFAULT NULL,
  sid         TINYINT  UNSIGNED NOT NULL DEFAULT 0,
  prio        SMALLINT          NOT NULL DEFAULT 0,
  host_number SMALLINT UNSIGNED NOT NULL DEFAULT 0,
  mx          VARCHAR(30)                DEFAULT NULL,
  PRIMARY KEY (host_id),
  KEY (db_id)
) ENGINE=InnoDB;

CREATE TABLE stop_words (
  word VARCHAR(40) NOT NULL DEFAULT '',
  ts   TIMESTAMP   NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (word)
) ENGINE=InnoDB;

CREATE TABLE stop_subwords (
  subword VARCHAR(40) NOT NULL DEFAULT '',
  ts      TIMESTAMP   NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (subword)
) ENGINE=InnoDB;

CREATE TABLE keyspaces (
  groupid    TINYINT UNSIGNED NOT NULL AUTO_INCREMENT,
  domainsuff VARCHAR(50)      NOT NULL DEFAULT '',
  tablename  VARCHAR(30)      NOT NULL DEFAULT '',
  addpref    TINYINT UNSIGNED NOT NULL DEFAULT 0,
  inuse      TINYINT UNSIGNED NOT NULL DEFAULT 1,
  PRIMARY KEY (groupid),
  UNIQUE KEY (domainsuff)
) ENGINE=InnoDB;

CREATE TABLE lrandoms (
  id      INT UNSIGNED NOT NULL AUTO_INCREMENT,
  keybody VARCHAR(64)  NOT NULL DEFAULT 0,
  start   DATETIME     NOT NULL DEFAULT '0000-00-00 00:00:00',
  valid   DATETIME     NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (id)
) ENGINE=InnoDB;

CREATE TABLE randoms (
  id      INT    UNSIGNED NOT NULL AUTO_INCREMENT,
  keybody VARBINARY(255)  NOT NULL DEFAULT '',
  start   TIMESTAMP       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id)
) ENGINE=InnoDB;

CREATE TABLE randoms_appauth (
  id      INT    UNSIGNED NOT NULL AUTO_INCREMENT,
  keybody VARBINARY(255)  NOT NULL DEFAULT '',
  start   TIMESTAMP       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id)
) ENGINE=InnoDB;

-- Не нужна в team
CREATE TABLE randoms_by (
  id      INT    UNSIGNED NOT NULL AUTO_INCREMENT,
  keybody VARBINARY(255)  NOT NULL DEFAULT '',
  start   TIMESTAMP       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id)
) ENGINE=InnoDB;

-- Не нужна в team
CREATE TABLE randoms_bya (
  id      INT    UNSIGNED NOT NULL AUTO_INCREMENT,
  keybody VARBINARY(255)  NOT NULL DEFAULT '',
  start   TIMESTAMP       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id)
) ENGINE=InnoDB;

-- Не нужна в team
CREATE TABLE randoms_com (
  id      INT    UNSIGNED NOT NULL AUTO_INCREMENT,
  keybody VARBINARY(255)  NOT NULL DEFAULT '',
  start   TIMESTAMP       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id)
) ENGINE=InnoDB;

-- Не нужна в team
CREATE TABLE randoms_comtr (
  id      INT    UNSIGNED NOT NULL AUTO_INCREMENT,
  keybody VARBINARY(255)  NOT NULL DEFAULT '',
  start   TIMESTAMP       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id)
) ENGINE=InnoDB;

-- Не нужна в team
CREATE TABLE randoms_fasttauth (
  id      INT    UNSIGNED NOT NULL AUTO_INCREMENT,
  keybody VARBINARY(255)  NOT NULL DEFAULT '',
  start   TIMESTAMP       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id)
) ENGINE=InnoDB;

-- Не нужна в team
CREATE TABLE randoms_kz (
  id      INT    UNSIGNED NOT NULL AUTO_INCREMENT,
  keybody VARBINARY(255)  NOT NULL DEFAULT '',
  start   TIMESTAMP       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id)
) ENGINE=InnoDB;

-- Не нужна в team
CREATE TABLE randoms_mk (
  id      INT    UNSIGNED NOT NULL AUTO_INCREMENT,
  keybody VARBINARY(255)  NOT NULL DEFAULT '',
  start   TIMESTAMP       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id)
) ENGINE=InnoDB;

-- Не нужна в team
CREATE TABLE randoms_mkbeta (
  id      INT    UNSIGNED NOT NULL AUTO_INCREMENT,
  keybody VARBINARY(255)  NOT NULL DEFAULT '',
  start   TIMESTAMP       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id)
) ENGINE=InnoDB;

CREATE TABLE randoms_mobilo (
  id      INT    UNSIGNED NOT NULL AUTO_INCREMENT,
  keybody VARBINARY(255)  NOT NULL DEFAULT '',
  start   TIMESTAMP       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id)
) ENGINE=InnoDB;

-- Не нужна в team
CREATE TABLE randoms_mpochta (
  id      INT    UNSIGNED NOT NULL AUTO_INCREMENT,
  keybody VARBINARY(255)  NOT NULL DEFAULT '',
  start   TIMESTAMP       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id)
) ENGINE=InnoDB;

-- Не нужна в team
CREATE TABLE randoms_ndx (
  id      INT    UNSIGNED NOT NULL AUTO_INCREMENT,
  keybody VARBINARY(255)  NOT NULL DEFAULT '',
  start   TIMESTAMP       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id)
) ENGINE=InnoDB;

-- Не нужна в team
CREATE TABLE randoms_pochta (
  id      INT    UNSIGNED NOT NULL AUTO_INCREMENT,
  keybody VARBINARY(255)  NOT NULL DEFAULT '',
  start   TIMESTAMP       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id)
) ENGINE=InnoDB;

-- Не нужна в team
CREATE TABLE randoms_signsmth (
  id      INT    UNSIGNED NOT NULL AUTO_INCREMENT,
  keybody VARBINARY(255)  NOT NULL DEFAULT '',
  start   TIMESTAMP       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id)
) ENGINE=InnoDB;

CREATE TABLE randoms_team (
  id      INT    UNSIGNED NOT NULL AUTO_INCREMENT,
  keybody VARBINARY(255)  NOT NULL DEFAULT '',
  start   TIMESTAMP       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id)
) ENGINE=InnoDB;

CREATE TABLE randoms_ua (
  id      INT    UNSIGNED NOT NULL AUTO_INCREMENT,
  keybody VARBINARY(255)  NOT NULL DEFAULT '',
  start   TIMESTAMP       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id)
) ENGINE=InnoDB;

-- Не нужна в team
CREATE TABLE randoms_ya (
  id      INT    UNSIGNED NOT NULL AUTO_INCREMENT,
  keybody VARBINARY(255)  NOT NULL DEFAULT '',
  start   TIMESTAMP       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id)
) ENGINE=InnoDB;

-- Не нужна в team
CREATE TABLE randoms_yandesru (
  id      INT    UNSIGNED NOT NULL AUTO_INCREMENT,
  keybody VARBINARY(255)  NOT NULL DEFAULT '',
  start   TIMESTAMP       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id)
) ENGINE=InnoDB;

--------------------------------------------------
--
-- shard
--

CREATE TABLE attributes (
  uid   BIGINT   UNSIGNED NOT NULL DEFAULT 0,
  type  SMALLINT UNSIGNED NOT NULL DEFAULT 0,
  value VARBINARY(65523)  NOT NULL DEFAULT '',
  PRIMARY KEY (uid, type)
) ENGINE=InnoDB;

-- Не нужна в team (всё равно создана, т.к. требуется переливщику)
CREATE TABLE password_history (
  uid                BIGINT   UNSIGNED NOT NULL DEFAULT 0,
  ts                 TIMESTAMP         NOT NULL DEFAULT CURRENT_TIMESTAMP,
  encrypted_password VARBINARY(255)    NOT NULL DEFAULT '',
  KEY (uid)
) ENGINE=InnoDB;

CREATE TABLE subscription_created (
  uid BIGINT   UNSIGNED NOT NULL DEFAULT 0,
  sid SMALLINT UNSIGNED NOT NULL DEFAULT 0,
  ts  TIMESTAMP         NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (uid, sid),
  KEY (sid, ts)
) ENGINE=InnoDB;

CREATE TABLE extended_attributes (
  uid         BIGINT   UNSIGNED NOT NULL DEFAULT 0,
  entity_type TINYINT  UNSIGNED NOT NULL DEFAULT 0,
  entity_id   BIGINT   UNSIGNED NOT NULL DEFAULT 0,
  type        SMALLINT UNSIGNED NOT NULL DEFAULT 0,
  value       VARBINARY(65514)  NOT NULL DEFAULT '',
  PRIMARY KEY (uid, entity_type, entity_id, type)
) ENGINE=InnoDB;

CREATE TABLE phone_operations (
  id                BIGINT  UNSIGNED NOT NULL AUTO_INCREMENT,
  uid               BIGINT  UNSIGNED NOT NULL DEFAULT 0,
  phone_id          BIGINT  UNSIGNED NOT NULL DEFAULT 0,
  security_identity BIGINT  UNSIGNED NOT NULL DEFAULT 0,
  type              TINYINT UNSIGNED NOT NULL DEFAULT 0,
  started           TIMESTAMP        NOT NULL DEFAULT CURRENT_TIMESTAMP,
  finished          TIMESTAMP        NOT NULL DEFAULT 0,
  code_value        VARCHAR(100)     NOT NULL DEFAULT '',
  code_checks_count TINYINT          NOT NULL DEFAULT 0,
  code_send_count   TINYINT          NOT NULL DEFAULT 0,
  code_last_sent    TIMESTAMP        NOT NULL DEFAULT 0,
  code_confirmed    TIMESTAMP        NOT NULL DEFAULT 0,
  password_verified TIMESTAMP        NOT NULL DEFAULT 0,
  flags             TINYINT UNSIGNED NOT NULL DEFAULT 0, -- bit0=ignore_bindlimit, bit1=aliasify
  phone_id2          BIGINT  UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (id),
  UNIQUE (uid, phone_id),          -- в пределах одного аккаунта может быть только одна операция для указанного телефона
  UNIQUE (uid, security_identity), -- в пределах одного аккаунта может быть только одна операция над защищённым телефоном
  KEY (finished, phone_id)
) ENGINE=InnoDB;

CREATE TABLE phone_bindings (
  number   BIGINT UNSIGNED NOT NULL DEFAULT 0,
  phone_id BIGINT UNSIGNED NOT NULL DEFAULT 0,
  uid      BIGINT UNSIGNED NOT NULL DEFAULT 0,
  bound    TIMESTAMP       NOT NULL DEFAULT 0,
  flags    TINYINT         NOT NULL DEFAULT 0, -- bit0=ignore_bindlimit
  PRIMARY KEY (number, uid), -- на одном аккаунте может быть только одна связка для одного и того же номера; для основной операции поиска uid'ов по номеру
  UNIQUE (phone_id),         -- для возможности доналивки потерянных связей телефон-аккаунт или обновления времени привязки
  KEY (uid)                  -- для удаления всех записей по uid'у
) ENGINE=InnoDB;

CREATE TABLE email_bindings (
  address  VARBINARY(500)  NOT NULL DEFAULT '',
  email_id BIGINT UNSIGNED NOT NULL DEFAULT 0,
  uid      BIGINT UNSIGNED NOT NULL DEFAULT 0,
  bound    TIMESTAMP       NOT NULL DEFAULT 0,
  PRIMARY KEY (address, uid),
  UNIQUE (email_id),
  KEY (uid)
) ENGINE=InnoDB;

CREATE TABLE phone_bindings_history (
  number BIGINT UNSIGNED NOT NULL DEFAULT 0,
  uid    BIGINT UNSIGNED NOT NULL DEFAULT 0,
  bound  TIMESTAMP       NOT NULL DEFAULT 0,
  PRIMARY KEY (number, bound, uid),
  KEY (bound)
) ENGINE=InnoDB;

CREATE TABLE tracks (
  id       BIGINT UNSIGNED  NOT NULL AUTO_INCREMENT,
  uid      BIGINT UNSIGNED  NOT NULL DEFAULT 0,
  track_id BINARY(32)       NOT NULL DEFAULT '',
  created  TIMESTAMP        NOT NULL DEFAULT CURRENT_TIMESTAMP,
  expired  TIMESTAMP        NOT NULL DEFAULT 0,
  content  VARBINARY(65477) NOT NULL DEFAULT '',
  PRIMARY KEY (id),
  UNIQUE KEY (track_id),
  KEY (uid),
  KEY (expired)
) ENGINE=InnoDB;

--------------------------------------------------
--
-- lookup
--

CREATE TABLE aliases_lookup (
  type SMALLINT UNSIGNED NOT NULL DEFAULT 0,
  name VARCHAR(255)      NOT NULL DEFAULT '',
  PRIMARY KEY (type)
) ENGINE=InnoDB;

INSERT INTO aliases_lookup (type, name) VALUES
 ( 1, 'portal')
,( 2, 'mail')
,( 3, 'narodmail')
,( 4, 'narod')
,( 5, 'lite')
,( 6, 'social')
,( 7, 'pdd')
,( 8, 'pddalias')
,( 9, 'galatasaray')
,(10, 'phonish')
,(11, 'phonenumber')
,(12, 'externalemail')
,(13, 'yandexoid')
;

CREATE TABLE attributes_lookup (
  type SMALLINT UNSIGNED NOT NULL DEFAULT 0,
  name VARCHAR(255)      NOT NULL DEFAULT '',
  PRIMARY KEY (type)
) ENGINE=InnoDB;

INSERT INTO attributes_lookup (type, name) VALUES
 ( 1, 'account.registration_datetime'    )
,( 2, 'account.user_defined_login'       )
,( 3, 'account.is_disabled'              )
,( 4, 'account.global_logout_datetime'   )
,( 5, 'account.have_pay_password'        )
,( 6, 'account.is_pdd_agreement_accepted')
,( 7, 'account.is_pdd_admin'             )
,( 8, 'account.is_betatester'            )
,( 9, 'account.is_corporate'             )
,(10, 'account.is_vip'                   )
,(11, 'account.is_test'                  )
,(12, 'account.is_employee'              )
,(13, 'account.is_shared_folder'         )
,(14, 'account.yandexoid_login'          )
,(15, 'person.contact_phone_number'      )
,(16, 'account.display_name'             )
,(17, 'karma.value'                      )
,(18, 'karma.activation_datetime'        )
,(19, 'password.encrypted'               )
,(20, 'password.update_datetime'         )
,(21, 'password.quality'                 )
,(22, 'password.is_changing_required'    )
,(23, 'password.is_creating_required'    )
,(24, 'password.is_strong_required'      )
,(25, 'hint.question.serialized'         )
,(26, 'hint.answer.encrypted'            )
,(27, 'person.firstname'                 )
,(28, 'person.lastname'                  )
,(29, 'person.gender'                    )
,(30, 'person.birthday'                  )
,(31, 'person.country'                   )
,(32, 'person.city'                      )
,(33, 'person.timezone'                  )
,(34, 'person.language'                  )
,(35, 'phone.number'                     )
,(36, 'phone.confirmation_datetime'      )
,(37, 'location.postal'                  )
,(38, 'subscription.mail.host_id'        )
,(39, 'subscription.mail.login_rule'     )
,(40, 'subscription.zakladki.suid'       )
,(41, 'subscription.narod.host_id'       )
,(42, 'subscription.narod.login_rule'    )
,(43, 'subscription.narod.suid'          )
,(44, 'subscription.fotki'               )
,(45, 'subscription.cards'               )
,(46, 'subscription.podpiska'            )
,(47, 'subscription.moikrug'             )
,(48, 'subscription.direct'              )
,(49, 'subscription.so'                  )
,(50, 'subscription.balance'             )
,(51, 'subscription.money.login_rule'    )
,(52, 'subscription.lenta'               )
,(53, 'subscription.partner'             )
,(54, 'subscription.market'              )
,(55, 'subscription.friends'             )
,(56, 'subscription.jabber.login_rule'   )
,(57, 'subscription.tv'                  )
,(58, 'subscription.afisha'              )
,(59, 'subscription.calendar'            )
,(60, 'subscription.public'              )
,(61, 'subscription.kuda'                )
,(62, 'subscription.video'               )
,(63, 'subscription.kraski'              )
,(64, 'subscription.slovari'             )
,(65, 'subscription.wwwdgt.mode'         )
,(66, 'subscription.disk.login_rule'     )
,(67, 'subscription.narod2.login_rule'   )
,(68, 'subscription.webmaster'           )
,(69, 'subscription.metrika'             )
,(70, 'subscription.maps'                )
,(71, 'subscription.musicpartner'        )
,(72, 'subscription.radiojam'            )
,(73, 'subscription.wikimaps'            )
,(74, 'subscription.xml'                 )
,(75, 'subscription.music'               )
,(76, 'subscription.mobilmail'           )
,(77, 'subscription.wdgt'                )
,(78, 'subscription.cloud'               )
,(79, 'subscription.newspartner'         )
,(80, 'subscription.cloudpaid'           )
,(81, 'subscription.gazeta'              )
,(82, 'subscription.mobilemusic'         )
,(83, 'subscription.mobilecloud'         )
,(84, 'subscription.cloudsoft'           )
,(85, 'subscription.cloudweb'            )
,(86, 'subscription.mailexp'             )
,(87, 'subscription.mailtest'            )
,(88, 'account.warnings'                 )
,(89, 'subscription.mynews'              )
,(90, 'subscription.storedevconsole'     )
,(91, 'subscription.pi'                  )
,(92, 'subscription.publicdemo'          )
,(93, 'subscription.gamification'        )
,(94, 'account.is_ad_campaign_participant')
,(95, 'subscription.livemail'            )
,(96, 'subscription.islandsapi'          )
,(97, 'subscription.postoffice'          )
,(98, 'avatar.default'                   )
,(99, 'subscription.merchant'            )
,(100, 'account.env_profiles'            )
,(101, 'account.browser_key'             )
,(102, 'account.bad_sessions'            )
;

CREATE VIEW readable_aliases AS
SELECT uid, name, value
FROM aliases a
  LEFT JOIN aliases_lookup l USING (type)
ORDER BY uid, type
;

CREATE VIEW readable_attributes AS
SELECT
  uid, name,
  IF(type IN (1,4,18,20,36), FROM_UNIXTIME(value), value) AS value
FROM attributes a
  LEFT JOIN attributes_lookup l USING (type)
ORDER BY uid, type
;
