-- MySQL dump 8.23
--
-- Host: localhost    Database: safeguarddb
---------------------------------------------------------
-- Server version	3.23.58-log

--
-- Table structure for table `CustomMorda`
--

DROP TABLE IF EXISTS CustomMorda;
CREATE TABLE CustomMorda (
  uid bigint(20) NOT NULL default '0',
  cookie text,
  create_time datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (uid)
) TYPE=MyISAM;

--
-- Table structure for table `account_ft`
--

DROP TABLE IF EXISTS account_ft;
CREATE TABLE account_ft (
  uid bigint(20) NOT NULL auto_increment,
  fio varchar(50) default NULL,
  email varchar(80) NOT NULL default '',
  hintq varchar(40) default NULL,
  hinta varchar(40) default NULL,
  reg_date datetime default NULL,
  ip_from varchar(16) NOT NULL default '',
  ip_prox varchar(16) NOT NULL default '',
  PRIMARY KEY  (uid),
  KEY x2 (email)
) TYPE=MyISAM;

--
-- Table structure for table `account_info`
--

DROP TABLE IF EXISTS account_info;
CREATE TABLE account_info (
  uid bigint(20) NOT NULL auto_increment,
  fio varchar(50) default NULL,
  sex tinyint(4) default NULL,
  birth_date date default '0000-00-00',
  country varchar(20) default NULL,
  region varchar(20) default NULL,
  city varchar(40) default NULL,
  charset varchar(30) default NULL,
  mail_format varchar(10) default NULL,
  icq varchar(20) default NULL,
  email varchar(80) NOT NULL default '',
  nickname varchar(40) default NULL,
  whatis varchar(40) default NULL,
  hintq varchar(40) default NULL,
  hinta varchar(40) default NULL,
  reg_date datetime default NULL,
  homepage varchar(80) default NULL,
  address varchar(50) default NULL,
  company varchar(50) default NULL,
  tel varchar(40) default NULL,
  fax varchar(40) default NULL,
  age int(11) default NULL,
  job varchar(40) default NULL,
  user_picture varchar(255) default NULL,
  zip varchar(40) default NULL,
  PRIMARY KEY  (uid),
  KEY x2 (email)
) TYPE=MyISAM;


CREATE TABLE `userinfo` (
      `uid` bigint(20) NOT NULL auto_increment,
      `firstname` varchar(50) default NULL,
      `lastname` varchar(50) default NULL,
      `sex` tinyint(4) default NULL,
      `birth_date` date default '0000-00-00',
      `country` varchar(20) default NULL,
      `city` varchar(50) default NULL,
      `email` varchar(80) NOT NULL default '',
      `nickname` varchar(40) default NULL,
      `reg_date` datetime default NULL,
      `tz` varchar(60) NOT NULL default 'Europe/Moscow',
      PRIMARY KEY  (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE ALGORITHM=MERGE VIEW account_info (
      uid, fio, sex,
      birth_date, country, region, city,
      charset, mail_format, icq, email, nickname,
      whatis, reg_date, homepage, address, company, tel, fax,
      age, job, user_picture, zip
) AS SELECT
  uid, CONVERT(CONCAT(lastname, ' ', firstname) USING cp1251), sex,
  birth_date, country, NULL, CONVERT(city USING cp1251),
  'windows-1251', 'plain', NULL, email, CONVERT(nickname USING cp1251),
  NULL, reg_date, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
FROM userinfo; 

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS accounts;
CREATE TABLE accounts (
  uid bigint(20) NOT NULL auto_increment,
  login varchar(40) NOT NULL default '',
  passwd varchar(40) NOT NULL default '',
  cryptpasswd varchar(40) NOT NULL default '',
  ena int(11) NOT NULL default '0',
  acl_id bigint(20) NOT NULL default '0',
  karma smallint(6) NOT NULL default '0',
  glogout bigint(20) NOT NULL default '1',
  PRIMARY KEY  (uid),
  UNIQUE KEY uq_index (login)
) TYPE=MyISAM;

--
-- Table structure for table `acls`
--

DROP TABLE IF EXISTS acls;
CREATE TABLE acls (
  acl_id bigint(20) NOT NULL auto_increment,
  sid bigint(20) NOT NULL default '0',
  num_entry int(11) NOT NULL default '0',
  ena int(11) NOT NULL default '0',
  PRIMARY KEY  (acl_id,sid)
) TYPE=MyISAM;

--
-- Table structure for table `authaction`
--

DROP TABLE IF EXISTS authaction;
CREATE TABLE authaction (
  actid bigint(20) NOT NULL auto_increment,
  actkey varchar(40) NOT NULL default '',
  keytype varchar(20) NOT NULL default 'login',
  acttype varchar(20) NOT NULL default 'sendmail',
  actdata blob,
  acttime datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (actid),
  KEY keyidx (actkey),
  KEY typeidx (acttype),
  KEY timeidx (acttime)
) TYPE=MyISAM;


--
-- Table structure for table `badauth_ip`
--

DROP TABLE IF EXISTS badauth_ip;
CREATE TABLE badauth_ip (
  ip varchar(16) NOT NULL default '',
  create_time datetime NOT NULL default '0000-00-00 00:00:00',
  KEY ip (ip),
  KEY `create_time` (`create_time`)
) TYPE=MyISAM;

--
-- Table structure for table `badauth_login`
--

DROP TABLE IF EXISTS badauth_login;
CREATE TABLE badauth_login (
  login varchar(40) NOT NULL default '',
  create_time datetime NOT NULL default '0000-00-00 00:00:00',
  KEY login (login),
  KEY `create_time` (`create_time`)
) TYPE=MyISAM;

--
-- Table structure for table `estart_info`
--

DROP TABLE IF EXISTS estart_info;
CREATE TABLE estart_info (
  suid bigint(20) NOT NULL default '0',
  mail_limit bigint(20) NOT NULL default '0',
  nickname varchar(20) default NULL,
  PRIMARY KEY  (suid)
) TYPE=MyISAM;

--
-- Table structure for table `flags`
--

DROP TABLE IF EXISTS flags;
CREATE TABLE flags (
  uid bigint(20) NOT NULL default '0',
  whitepages tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (uid)
) TYPE=MyISAM;

--
-- Table structure for table `fotki_info`
--

DROP TABLE IF EXISTS fotki_info;
CREATE TABLE fotki_info (
  suid bigint(20) NOT NULL default '0',
  PRIMARY KEY  (suid)
) TYPE=MyISAM;

--
-- Table structure for table `horo_info`
--

DROP TABLE IF EXISTS horo_info;
CREATE TABLE horo_info (
  suid bigint(20) NOT NULL default '0',
  PRIMARY KEY  (suid)
) TYPE=MyISAM;

--
-- Table structure for table `hosts`
--

DROP TABLE IF EXISTS hosts;
CREATE TABLE hosts (
  host_id int(11) NOT NULL auto_increment,
  host_ip varchar(16) default NULL,
  host_name varchar(255) default NULL,
  db_id varchar(40) default NULL,
  sid bigint(20) NOT NULL default '0',
  prio int(11) NOT NULL default '0',
  host_number bigint(20) NOT NULL default '0',
  mx varchar(30) default NULL,
  PRIMARY KEY  (host_id)
) TYPE=MyISAM;

--
-- Table structure for table `messagebodies`
--

DROP TABLE IF EXISTS messagebodies;
CREATE TABLE messagebodies (
  messid bigint(20) NOT NULL default '0',
  message blob,
  PRIMARY KEY  (messid)
) TYPE=MyISAM COMMENT='added by zappa 2002-02-15 as compliment to usermessages' DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Table structure for table `narod_info`
--

DROP TABLE IF EXISTS narod_info;
CREATE TABLE narod_info (
  suid bigint(20) NOT NULL default '0',
  mail_limit bigint(20) NOT NULL default '0',
  nickname varchar(40) default NULL,
  narod_limit int(11) default NULL,
  default_site int(11) NOT NULL default '0',
  PRIMARY KEY  (suid)
) TYPE=MyISAM;

--
-- Table structure for table `narodmail_info`
--

DROP TABLE IF EXISTS narodmail_info;
CREATE TABLE narodmail_info (
  suid bigint(20) NOT NULL default '0',
  mail_limit bigint(20) NOT NULL default '0',
  nickname varchar(50) default NULL,
  PRIMARY KEY  (suid)
) TYPE=MyISAM;

--
-- Table structure for table `neto_info`
--

DROP TABLE IF EXISTS neto_info;
CREATE TABLE neto_info (
  suid bigint(20) NOT NULL default '0',
  mail_limit bigint(20) NOT NULL default '20124',
  nickname varchar(20) default NULL,
  PRIMARY KEY  (suid)
) TYPE=MyISAM;

--
-- Table structure for table `not_moderated_faces`
--

DROP TABLE IF EXISTS not_moderated_faces;
CREATE TABLE not_moderated_faces (
  uid bigint(20) NOT NULL default '0',
  user_picture varchar(255) default NULL,
  PRIMARY KEY  (uid)
) TYPE=MyISAM;

--
-- Table structure for table `pop_sessions`
--

DROP TABLE IF EXISTS pop_sessions;
CREATE TABLE pop_sessions (
  login varchar(40) NOT NULL default '',
  login_time datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (login)
) TYPE=MyISAM;

--
-- Table structure for table `randoms`
--

DROP TABLE IF EXISTS randoms;
CREATE TABLE randoms (
  id int(11) NOT NULL auto_increment,
  keybody bigint(20) unsigned NOT NULL default '0',
  start timestamp(14) NOT NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Table structure for table `lrandoms`
--

DROP TABLE IF EXISTS lrandoms;
CREATE TABLE lrandoms (
  id int(11) NOT NULL auto_increment,
  keybody varchar(64) NOT NULL default '0',
  start  datetime NOT NULL default '0000-00-00 00:00:00',
  valid  datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Table structure for table `registrations`
--

DROP TABLE IF EXISTS registrations;
CREATE TABLE registrations (
  registr_id varchar(40) NOT NULL default '',
  uid bigint(20) NOT NULL default '0',
  create_time datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (registr_id)
) TYPE=MyISAM;

--
-- Table structure for table `remember_keys`
--

DROP TABLE IF EXISTS remember_keys;
CREATE TABLE remember_keys (
  key_id varchar(40) NOT NULL default '',
  uid bigint(20) NOT NULL default '0',
  create_time datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (uid),
  UNIQUE KEY key_id (key_id)
) TYPE=MyISAM;

--
-- Table structure for table `remember_sms_keys`
--

DROP TABLE IF EXISTS remember_sms_keys;
CREATE TABLE remember_sms_keys (
  keyid bigint(20) NOT NULL auto_increment,
  keybody varchar(10) NOT NULL default '',
  uid bigint(20) NOT NULL default '0',
  smsid bigint(20) NOT NULL,
  create_time datetime NOT NULL,
  touch_time datetime NOT NULL,
  status enum('ready', 'localqueue', 'senttosmsc', 'notsenttosmsc', 'queued', 'delivered', 'notdelivered') NOT NULL DEFAULT 'ready',
  PRIMARY KEY (keyid),
  KEY touch_time (touch_time),
  KEY uid_sms (uid, smsid),
  KEY uid_key (uid, keybody)
) TYPE=MyISAM;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS services;
CREATE TABLE services (
  name varchar(80) NOT NULL default '',
  sid bigint(20) NOT NULL auto_increment,
  rules bigint(20) NOT NULL default '0',
  serv_table_name varchar(20) default NULL,
  alias varchar(20) NOT NULL default '',
  PRIMARY KEY  (sid),
  UNIQUE KEY name (name)
) TYPE=MyISAM;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS sessions;
CREATE TABLE sessions (
  session_id varchar(255) NOT NULL default '',
  uid bigint(20) NOT NULL default '0',
  suid bigint(20) NOT NULL default '0',
  sid bigint(20) NOT NULL default '0',
  acl_id bigint(20) NOT NULL default '0',
  grant_rule bigint(20) default NULL,
  last_access datetime NOT NULL default '0000-00-00 00:00:00',
  expire_time datetime default NULL,
  PRIMARY KEY  (session_id),
  KEY last_access (last_access),
  KEY uid (uid)
) TYPE=MyISAM;

--
-- Table structure for table `spam`
--

DROP TABLE IF EXISTS spam;
CREATE TABLE spam (
  spam_id bigint(20) NOT NULL auto_increment,
  sid bigint(20) default NULL,
  title varchar(150) default NULL,
  description varchar(255) default NULL,
  PRIMARY KEY  (spam_id)
) TYPE=MyISAM;

--
-- Table structure for table `stop_registration`
--

DROP TABLE IF EXISTS stop_registration;
CREATE TABLE stop_registration (
  word varchar(40) NOT NULL default '',
  update_date timestamp(14) NOT NULL,
  PRIMARY KEY  (word)
) TYPE=MyISAM;

--
-- Table structure for table `stop_words`
--

DROP TABLE IF EXISTS stop_words;
CREATE TABLE stop_words (
  word varchar(40) NOT NULL default '',
  update_date timestamp(14) NOT NULL,
  word_type tinyint(4) NOT NULL default '0',
  uid bigint(20) NOT NULL default '0',
  PRIMARY KEY  (word)
) TYPE=MyISAM;

--
-- Table structure for table `subscription`
--

DROP TABLE IF EXISTS subscription;
CREATE TABLE subscription (
  suid bigint(20) NOT NULL auto_increment,
  sid bigint(20) NOT NULL default '0',
  uid bigint(20) NOT NULL default '0',
  login varchar(40) NOT NULL default '',
  passwd varchar(40) default NULL,
  host_id int(11) default NULL,
  login_rule bigint(20) NOT NULL default '1',
  born_date date default NULL,
  PRIMARY KEY  (suid,sid),
  UNIQUE KEY lg (login,sid),
  KEY x1 (uid)
) TYPE=MyISAM;

--
-- Table structure for table `usermessages`
--

DROP TABLE IF EXISTS usermessages;
CREATE TABLE usermessages (
  mid bigint(20) NOT NULL auto_increment,
  uid bigint(20) NOT NULL default '0',
  showid varchar(40) NOT NULL default 'all',
  number int(11) NOT NULL default '0',
  messref bigint(20) NOT NULL default '0',
  message blob,
  datebegin bigint(20) unsigned NOT NULL default '0',
  dateend bigint(20) unsigned NOT NULL default '0',
  timestart int(11) unsigned default NULL,
  timeend int(11) unsigned default NULL,
  PRIMARY KEY  (mid),
  KEY uid (uid)
) TYPE=MyISAM COMMENT='created by zappa 2002-02-15 for user messages';

--
-- Table structure for table `victym`
--

DROP TABLE IF EXISTS victym;
CREATE TABLE victym (
  sub_id bigint(20) NOT NULL auto_increment,
  spam_id bigint(20) NOT NULL default '0',
  uid bigint(20) NOT NULL default '0',
  suid bigint(20) default NULL,
  sid bigint(20) default NULL,
  email varchar(80) default NULL,
  nickname varchar(40) default NULL,
  date_stamp datetime default NULL,
  ena int(11) NOT NULL default '0',
  unique_valid varchar(40) default NULL,
  PRIMARY KEY  (sub_id),
  KEY victym_uid (uid),
  KEY suid (suid),
  KEY unique_valid (unique_valid)
) TYPE=MyISAM;

--
-- Table structure for table `www_info`
--

DROP TABLE IF EXISTS www_info;
CREATE TABLE www_info (
  suid bigint(20) NOT NULL default '0',
  PRIMARY KEY  (suid)
) TYPE=MyISAM;

--
-- Table structure for table `yamail_info`
--

DROP TABLE IF EXISTS yamail_info;
CREATE TABLE yamail_info (
  suid bigint(20) NOT NULL default '0',
  mail_limit bigint(20) NOT NULL default '0',
  nickname varchar(50) default NULL,
  PRIMARY KEY  (suid)
) TYPE=MyISAM;

--
-- Table structure for table `zak_info`
--

DROP TABLE IF EXISTS zak_info;
CREATE TABLE zak_info (
  suid bigint(20) NOT NULL default '0',
  PRIMARY KEY  (suid)
) TYPE=MyISAM;

--
-- Table structure for table `balance_info`
--

DROP TABLE IF EXISTS balance_info;
CREATE TABLE balance_info (
  suid bigint(20) NOT NULL default '0',
  balance_id bigint(20) NOT NULL default '0',
  root tinyint(1) NOT NULL default '0',
  PRIMARY KEY (suid)
) TYPE=MyISAM;

--
-- Table structure for table `spasswd` 
--

DROP TABLE IF EXISTS spasswd;
CREATE TABLE spasswd (
  uid bigint(20) NOT NULL default '0',
  passwd varchar(40) default NULL,
  born_date datetime default NULL,
  PRIMARY KEY (uid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS admin;
CREATE TABLE admin (
  uid bigint(20) NOT NULL default '0',
  action enum('edit','delete','mailsidrestore') NOT NULL default 'edit',
  UNIQUE KEY rights (uid,action),
  KEY uid (uid)
) TYPE=MyISAM;

DROP TABLE IF EXISTS account_ft_login;
CREATE TABLE account_ft_login (
  uid bigint(20) NOT NULL,
  login varchar(40) NOT NULL default '',
  PRIMARY KEY (uid),
  KEY k_login (login)
) TYPE=MyISAM;

DROP TABLE IF EXISTS keyspaces;
CREATE TABLE keyspaces (                                            
	groupid integer(10) unsigned not null auto_increment,
	domainsuff varchar(50) not null default "",
	tablename varchar(30) not null default "randoms",
	addpref tinyint(3) not null default 0,
	inuse tinyint(3) not null default 1,
	primary key pk_gid(groupid),
	unique key uk_domain(domainsuff)
);      
insert into keyspaces values (null, "yandex_ru", "randoms", 0, 1); 
insert into keyspaces values (null, "yandex_ua", "randoms_ua", 0, 1);
insert into keyspaces values (null, "mobilo", "randoms_mobilo", 0, 1);
insert into keyspaces values (null, "appauth", "randoms_appauth", 0, 1);
insert into keyspaces values (null, "fasttauth", "randoms_fasttauth", 0, 1);

-- for ua

DROP TABLE IF EXISTS randoms_ua;
CREATE TABLE randoms_ua (
  id int(11) NOT NULL auto_increment,
  keybody bigint(20) unsigned NOT NULL default '0',
  start timestamp(14) NOT NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

-- for mobile auth

DROP TABLE IF EXISTS randoms_mobilo;
CREATE TABLE randoms_mobilo (
  id int(11) NOT NULL auto_increment,
  keybody bigint(20) unsigned NOT NULL default '0',
  start timestamp(14) NOT NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

-- for application auth

DROP TABLE IF EXISTS randoms_appauth;
CREATE TABLE randoms_appauth (
  id int(11) NOT NULL auto_increment,
  keybody bigint(20) unsigned NOT NULL default '0',
  start timestamp(14) NOT NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Cardspace
--

DROP TABLE IF EXISTS cardspace;
CREATE TABLE cardspace (
  recid bigint(20) NOT NULL auto_increment,
  uid bigint(20) NOT NULL default '0',
  msid varchar(255) NOT NULL DEFAULT "",
  create_time timestamp(14) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  primary key (recid, uid),
  KEY byppid(msid)
) TYPE=MyISAM;

--
-- captcha
--

DROP TABLE IF EXISTS captcha;
CREATE TABLE captcha (
  uid bigint(20) NOT NULL,
  create_time datetime NOT NULL,
  valid_till datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (uid, valid_till)
) TYPE=MyISAM;

--
-- capthca ip
-- 

DROP TABLE IF EXISTS captcha_ip;
create table captcha_ip ( 
	ip varchar(16) not null, 
	create_time datetime not null default '0000-00-00 00:00:00', 
	valid_till datetime not null default '0000-00-00 00:00:00', 
	PRIMARY KEY(ip, valid_till) 
) TYPE = MyISAM;

--
-- Delayed letters
--

DROP TABLE IF EXISTS letters;
CREATE TABLE letters (
  recid bigint(20) NOT NULL auto_increment,
  uid bigint(20) NOT NULL,
  create_time datetime NOT NULL,
  send_time datetime NOT NULL,
  send_before datetime NOT NULL,
  email varchar(80) NOT NULL,
  message varchar(10) NOT NULL,
  data blob,
  sent int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (recid, send_time, send_before, sent),
  KEY x2 (uid, message, sent)
) TYPE=MyISAM;

--
-- Fished users
--

DROP TABLE IF EXISTS fished;
CREATE TABLE fished (
  recid bigint(20) NOT NULL auto_increment,
  uid bigint(20) NOT NULL,
  fisherid VARCHAR(7) NOT NULL,
  PRIMARY KEY (recid, uid),
  KEY fishers (fisherid)
) TYPE=MyISAM;


--
-- Table structure for table `badreg_ip`
--

DROP TABLE IF EXISTS badreg_ip;
CREATE TABLE badreg_ip (
  ip INT UNSIGNED NOT NULL,
  ts TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  KEY ip_ts (ip, ts),
  KEY ts (ts)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS location;
CREATE TABLE location (                                                                                                                                                                                                             
  uid     BIGINT UNSIGNED NOT NULL,
  type    TINYINT UNSIGNED NOT NULL,
  address VARBINARY(4096) NOT NULL, 
  UNIQUE KEY (uid, type)
) ENGINE=MyISAM;

