from urllib.parse import urljoin

from passport.backend.pocket_service.utils.secrets import get_secrets
from passport.backend.pocket_service.utils.tvm import get_service_ticket_for
import requests


class ABC(object):
    """
    https://wiki.yandex-team.ru/intranet/abc/api/
    """
    def __init__(self, url='https://abc-back.yandex-team.ru/', token=None, session_id=None):
        self.url = url
        self.token = token
        self.session_id = session_id

    def auth_header(self, is_duty_v2=False):
        # В дежурствах 2.0 авторизация только через tvm.
        if is_duty_v2:
            return {'X-Ya-Service-Ticket': get_service_ticket_for('watcher_back')}

        # Если можем - ходим от имени пользователя. Иначе - от имени робота.
        if self.session_id is not None:
            return {'Cookie': 'Session_id=%s' % self.session_id}
        else:
            return {'Authorization': 'OAuth %s' % self.token}

    def who_is_on_duty(self, shedule_slug):
        return requests.Request(
            method='GET',
            url=urljoin(self.url, 'api/v4/duty/on_duty/'),
            params={
                'schedule__slug': shedule_slug,
            },
            headers=self.auth_header(),
        ).prepare()

    def get_duty_v2_schedule_id_by_slug(self, shedule_slug):
        return requests.Request(
            method='GET',
            url=urljoin(self.url, 'api/watcher/v1/schedule/'),
            params={
                'filter': 'slug={slug}'.format(slug=shedule_slug),
            },
            headers=self.auth_header(is_duty_v2=True),
        ).prepare()

    def who_is_on_duty_v2(self, shedule_id):
        return requests.Request(
            method='GET',
            url=urljoin(self.url, 'api/watcher/v1/shift/'),
            params={
                'current': True,
                'filter': 'schedule_id={id},is_primary=true'.format(id=shedule_id),
            },
            headers=self.auth_header(is_duty_v2=True),
        ).prepare()


def get_abc(session_id=None):
    return ABC(token=get_secrets()['ABC_SECRET'], session_id=session_id)
