from urllib.parse import urljoin

from passport.backend.pocket_service.utils.secrets import get_secrets
import requests


class Conductor(object):
    """
    https://wiki.yandex-team.ru/conductor/api/nav/
    """
    def __init__(self, url='https://c.yandex-team.ru/api/', token=None):
        self.url = url
        self.token = token

    def oauth_header(self):
        return {'Authorization': 'OAuth {token}'.format(token=self.token)}

    def ticket_info(self, ticket_id):
        return requests.get(
            url=urljoin(self.url, 'v1/tickets/{ticket_id}/'.format(ticket_id=ticket_id)),
            headers=self.oauth_header(),
        ).json()['value']


def get_conductor():
    return Conductor(token=get_secrets()['CONDUCTOR_SECRET'])
