import json

from passport.backend.pocket_service.utils.secrets import get_secrets
import requests


class GithubException(Exception):
    pass


class Github(object):
    def __init__(self, url='https://api.github.yandex-team.ru', token=None):
        self.url = url
        self.token = token

    def oauth_header(self):
        return {'Authorization': 'token {token}'.format(token=self.token)}

    def github_request(self, owner, repo, suffix, http_method, data=None):
        url = self.url + '/repos/{}/{}/{}'.format(owner, repo, suffix)
        headers = self.oauth_header()
        headers['Content-Type'] = 'applications/json'
        response = requests.request(
            method=http_method,
            url=url,
            headers=headers,
            data=data,
        )
        return response.json()

    def update_pull_request(self, owner, repo, pr_no, data):
        return self.github_request(
            owner,
            repo,
            'pulls/{}'.format(pr_no),
            http_method='PATCH',
            data=json.dumps(data),
        )


def get_github():
    return Github(token=get_secrets()['GITHUB_SECRET'])
