from urllib.parse import urljoin

from passport.backend.pocket_service.utils.secrets import get_secrets
import requests


class MollyException(Exception):
    pass


class Molly(object):
    """
    https://wiki.yandex-team.ru/product-security/molly/api/1.1/
    """

    def __init__(self, url='https://molly.yandex-team.ru', token=None):
        self.url = url
        self.token = token

    def oauth_header(self):
        return {'Authorization': 'OAuth %s' % self.token}

    def start_scan(self, molly_params):
        return requests.Request(
            method='POST',
            url=urljoin(self.url, '/api/v1.1/scan/'),
            data=molly_params,
            headers=self.oauth_header(),
        ).prepare()

    def get_scan_status(self, scan_id):
        return requests.Request(
            method='GET',
            url=urljoin(self.url, '/api/v1.1/scan/{}' % scan_id),
            headers=self.oauth_header(),
        ).prepare()


def get_molly():
    return Molly(token=get_secrets()['MOLLY_SECRET'])


def get_molly_params(package_name, target_env):
    configs = {
        'yandex-passport-frontend': {
            'testing': {
                'target': 'Passport Frontend',
                'target_uri': 'https://passport-test.yandex.ru',
                'auth_profile': '38b57da1-7e85-4b2c-97d0-07f6907a7dcd',
            },
            'stable': {
                'target': 'Passport Frontend',
                'target_uri': 'https://passport.yandex.ru',
                'auth_profile': '3d1028d1-3c05-4379-9975-d21f41a6636e',
            },
        },
        'yandex-passport-api': {
            'testing': {
                'target': 'Passport API',
                'target_uri': 'https://passport-test-internal.yandex.ru',
                'auth_profile': '38b57da1-7e85-4b2c-97d0-07f6907a7dcd',
            },
            'stable': {
                'target': 'Passport API',
                'target_uri': 'https://passport-internal.yandex.ru',
                'auth_profile': '3d1028d1-3c05-4379-9975-d21f41a6636e',
            },
        },
    }

    effective_config = configs[package_name][target_env]

    molly_params = {
        "profile": "Yandex",  # профиль сканирования (всегда "Yandex", если не обсудили c СИБ иное)
        "abc_id": 14,  # оциональный числовой параметр, задает идентификатор проекта в ABC
        # (используется для контроля включения Молли в Сервисе)
        "st_queue": "PASSP",  # опциональный параметр, задает очередь в ST для данного сканирования
        "users": "passport-test-reports@yandex-team.ru",  # опциональный параметр,
        # список сотрудников (через запятую), которые будут получать уведомления о найденных уязвимостях

        # target — опциональный параметр, задает имя сервиса сканирования,
        # нужен тогда, когда нужно объединять одинаковые уязвимости в пределах разных тестовых сред
        # target_uri — URL сервиса,
        # предварительно должен быть заказан доступ от макроса C_MOLLY_AGENTS
        # для тестовых сред обычно уже имеется доступ из AERONETS, включающий в себя нужные сети
        # auth_profile — оциональный параметр,
        # задает уникальный идентификатор профиля аутентификации,
        # учетная запись которого будет использоваться при сканировании

        # target_map - опциональный параметр, задает идентификатор карты сайта
        # (списка URL, которые необходимо включить в сканирование)
    }
    molly_params.update(**effective_config)
    return molly_params
