import json

from passport.backend.pocket_service.utils.secrets import get_secrets
import requests


class TeamCity(object):
    def __init__(self, url='https://teamcity.yandex-team.ru', username=None, password=None):
        self.url = url
        self.username = username
        self.password = password

    def do_rebase(self, owner, project, pr_no):
        data = {
            'buildType': {
                'id': 'PassportAutorebase',
            },
            'properties': {
                'property': [
                    {
                        'name': 'gh.owner',
                        'value': owner,
                    },
                    {
                        'name': 'gh.repo',
                        'value': project,
                    },
                    {
                        'name': 'autorebase.params',
                        'value': '--pull-request {}'.format(pr_no),
                    },
                ],
            },
        }
        url = self.url + '/app/rest/buildQueue'
        headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
        }
        response = requests.post(
            url,
            headers=headers,
            data=json.dumps(data),
            auth=(self.username, self.password),
        )
        return response.json()


def get_teamcity():
    username = get_secrets()['TEAMCITY_USERNAME_SECRET']
    password = get_secrets()['TEAMCITY_PASSWORD_SECRET']
    return TeamCity(username=username, password=password)
