import tvmauth

from passport.backend.pocket_service.utils.secrets import get_secrets


tvm_client = None


def init_tvm_client():
    global tvm_client
    tvm_client = tvmauth.TvmClient(
        tvmauth.TvmApiClientSettings(
            self_tvm_id=2035841,
            self_secret=get_secrets()['TVM_SECRET'],
            dsts={'watcher_back': 2027882},
            disk_cache_dir='/var/cache/yandex/passport-pocket-service/tvm',
        )
    )


def get_service_ticket_for(alias):
    return tvm_client.get_service_ticket_for(alias)
