import logging

from passport.backend.pocket_service.utils.http import requests_retry_session
from passport.backend.pocket_service.utils.startrek import (
    get_startrek,
    get_startrek_client,
)


def find_release_ticket(search_query):
    request = get_startrek().search(search_query, page=1, per_page=1)

    response = requests_retry_session().send(request, verify=False).json()

    for ticket in response:
        return 'https://st.yandex-team.ru/' + ticket['key']


def get_passport_current_release():
    # Компоненты:
    #  - 4280 = %Бэкенд
    #  - 4269 = @Паспорт
    return find_release_ticket('Queue:PASSP Type:Release Components:4280 Components:4269')


def get_frontend_current_release():
    # Компоненты:
    #  - 4281 = %Фронтенд
    #  - 4269 = @Паспорт
    return find_release_ticket('Queue:PASSP Type:Release Components:4281 Components:4269')


def synchronize_am_release_ticket_and_version():
    """
    Синхроонизация тикетов в релизных версиях и релизных тикетах для очереди MOBDEVAUTH
    * Тикеты без версии, слинкованные с релизным, получают версию из релизного тикета
    * Тикеты с релизной версией, не слинкованные с релизным тикетом, линкуются к релизному тикету
    * Тикеты слинкованные с релизным тикетом, но с отличающейся релизной версией, отлинковываются от релизного тикета
    """
    st = get_startrek_client()
    current_release_tickets = st.issues.find('Queue: MOBDEVAUTH Type: Release Resolution: empty()')

    for release_ticket in current_release_tickets:
        release_versions = release_ticket.fixVersions
        if len(release_versions) == 1:
            release_version = release_versions[0]
            tickets_linked_with_release_with_empty_version = st.issues.find(
                'Queue: MOBDEVAUTH Type: !Release "Fix Version": empty() "Linked To": {}'.format(release_ticket.key)
            )
            for ticket in tickets_linked_with_release_with_empty_version:
                logging.debug('Setting {version} for {ticket}'.format(version=release_version.name, ticket=ticket.key))
                ticket.update(fixVersions=release_version.name, params={'notify': False, 'isAddToFollowers': False})

            tickets_with_release_version_not_linked_with_release = st.issues.find(
                'Queue: MOBDEVAUTH Type: !Release "Fix Version": {version} "Linked To": !{ticket}'.format(
                    version=release_version.name,
                    ticket=release_ticket.key,
                )
            )
            for ticket in tickets_with_release_version_not_linked_with_release:
                logging.debug(
                    'Linking {ticket} with release {release}'.format(ticket=ticket.key, release=release_ticket.key)
                )
                release_ticket.links.create(
                    issue=ticket.key, relationship='relates', params={'notify': False, 'isAddToFollowers': False}
                )

            tickets_with_other_release_version_linked_with_release = st.issues.find(
                'Queue: MOBDEVAUTH Type: !Release '
                '"Fix Version": !{version} "Fix Version": !empty() "Linked To": {ticket}'.format(
                    version=release_version.name,
                    ticket=release_ticket.key,
                )
            )
            for ticket in tickets_with_other_release_version_linked_with_release:
                release_ticket_link_ids = [rt_link.id for rt_link in release_ticket.links]
                for link in ticket.links:
                    if link.id in release_ticket_link_ids:
                        logging.debug(
                            'Unlinking {ticket} from release {release}'.format(ticket=ticket.key,
                                                                               release=release_ticket.key)
                        )
                        link.delete()
                        break
