from passport.backend.pocket_service.utils.conductor import get_conductor
from passport.backend.pocket_service.utils.http import requests_retry_session
from passport.backend.pocket_service.utils.startrek import get_startrek


def create_deployment_ticket_from_conductor_ticket(conductor_ticket_id, st_queue, assignee=None, session_id=None):
    ticket_info = get_conductor().ticket_info(conductor_ticket_id)
    branch = ticket_info['branch']
    packages_with_versions = ticket_info['packages_with_versions']
    conductor_ticket_comment = ticket_info['comment']
    conductor_ticket_url = 'https://c.yandex-team.ru/tickets/{ticket_id}'.format(ticket_id=conductor_ticket_id)

    if not packages_with_versions:
        raise ValueError('Ticket %s is empty' % conductor_ticket_id)

    package_info = '{name}={version}'.format(**packages_with_versions[0])
    if len(packages_with_versions) > 1:
        package_info += u' (и ещё {n})'.format(n=len(packages_with_versions) - 1)

    request = get_startrek(session_id=session_id).create_ticket(
        queue=st_queue,
        title=u'Выложить {package_info} в {branch}'.format(package_info=package_info, branch=branch),
        body=u'Кондукторный тикет: {conductor_url}\n\n{conductor_comment}'.format(
            conductor_url=conductor_ticket_url,
            conductor_comment=conductor_ticket_comment,
        ),
        assignee=assignee,
    )

    response = requests_retry_session().send(request, verify=False).json()
    ticket_id = response.get('key')
    if not ticket_id:
        raise RuntimeError('Failed to create ST ticket: %s' % response)
    return 'https://st.yandex-team.ru/{ticket_id}'.format(ticket_id=ticket_id)
