import logging
import time

from passport.backend.pocket_service.utils.infra import get_infra


def package_deploying_started(request):
    target_package = request['package']
    target_env = request['env']
    service_id = request.get('service_id', 1649)  # 1649 - паспорт
    environment_id = request.get('environment_id', 2520)  # 2520 - паспорт
    if target_env not in ['production']:
        logging.debug('Package is deploying to environment "{}". Do nothing'.format(target_env))
        return

    ongoing_events = get_infra().get_events(
        service_id=service_id,
        environment_id=environment_id,
        delta=0,
    )
    if len(ongoing_events) > 0:
        logging.debug('Event already created')
        return

    get_infra().create_event(
        service_id=service_id,
        environment_id=environment_id,
        title='Выкатка пакета {}'.format(target_package),
        meta={
            'package': target_package,
        },
    )

    time.sleep(1)
    ongoing_events = get_infra().get_events(
        service_id=service_id,
        environment_id=environment_id,
        delta=0,
    )
    if len(ongoing_events) > 1:
        ids = [event['id'] for event in ongoing_events]
        earliest_event_id = min(ids)
        for ongoing_event_id in ids:
            if ongoing_event_id != earliest_event_id:
                logging.debug(
                    'Event {} is duplicate for event {}. Removing it'.format(
                        ongoing_event_id,
                        earliest_event_id,
                    )
                )
                get_infra().delete_event(ongoing_event_id)
