# Паспортный профиль

Паспортные профили - это таблица с информацией об авторизациях пользователя в Паспорте.
На каждую авторизацию пользователя в таблицу сохраняется время, user-agent и IP, откуда была совершена авторизация.
Далее эта информация используется при последующих входах пользователя для определения того,
насколько сильно отличается новый вход от старых. Если отличие сильное, то считается, что войти пытается злоумышленник и
показывается "челлендж" (капча, СМС-ка), призванный остановить его.

## Виды профилей

Для каждого пользователя хранятся два вида профилей - свежий и полный. Свежие профили заливаются в течение дня, всего в таблице
хранится максимум 50 последних свежих профилей. Полные профили расчитываются в начале каждого дня на основе данных
за последние полгода.

Свежий профиль содержит информацию об одной авторизации, полный профиль состоит из сводной статистики и гистограмм
об авторизациях за последние полгода.

Оба вида профилей хранятся рядом друг с другом в одной и той же таблице.

## Технические детали.

Профили хранятся в [таблице на YDB](https://ydb.yandex-team.ru/db/ydb-ru/passport-data/prod/passport-users/browser).
Заливка полных профилей осуществляется [пакетом profile](https://a.yandex-team.ru/arc/trunk/arcadia/passport/backend/profile) раз в день, а
заливка свежих профилей осуществляется непрерывно [логброкер-клиентом UFO](https://a.yandex-team.ru/arc/trunk/arcadia/passport/backend/logbroker_client/ufo).

Запуск расчета полного профиля происходит в `scripts/build_profile_daily.py`.
Первичная обработка логов в `jobs/blackbox_events.py`, `jobs/passport_events.py` и `jobs/oauth_events.py`.
Составление гистограмм из полученных данных в `jobs/calculate_auth_frequencies.py`.
В конце происходит заливка полученных в YDB скриптом `scripts/upload_profile_to_ydb.py`
Мониторинг заливки живет в `monitor`.

## Собрать релиз в Нирване
Для сборки релиза и заливки в Нирвану руками можно использовать следующую команду в папке bin:
`ya make --checkout --target-platform default-linux-x86_64 --target-platform-build-type release && ya upload ./passport-profile --type SANDBOX_BINARY --arch=linux --ttl inf --owner PASSPORT --description=...`
В консоли будет результат загрузки в виде номера ресурса - 10тизначное число.
В нирване необходимо создать новый инстанс нашего flow через кнопку clone и установить глобальный параметр binary-sabdbox-id = номера ресурса полученного выше. Нажать Save. Назначить новый инстанс главным кнопкой `Main`.

Для отработки заливки из YT в YDB необходим токен с именем `default_kikimr` зарегистрированный в YQL. [Как это сделать](https://ydb.yandex-team.ru/docs/getting_started/start_auth/)
