# -*- coding: utf-8 -*-

import logging.config

from nile.api.v1 import clusters
from yql.api.v1.client import YqlClient


APP_INITIALIZED = False


def initialize_app(config):
    global APP_INITIALIZED

    if not APP_INITIALIZED:
        config.set_logging()

        root_logger = logging.getLogger()
        for library in ('nile', 'requests', 'urllib3', 'yt', 'Yt', 'qb2'):
            logger = logging.getLogger(library)
            # Убедимся, что логи сторонних библиотек обрабатываются только нами
            logger.handlers = list(root_logger.handlers)
            logger.setLevel(logging.WARNING)

        # Не хотим в выводе видеть предупреждения от QB2
        logging.captureWarnings(capture=True)
        APP_INITIALIZED = True


def get_cluster(config):
    return clusters.YT(
        proxy='%s.yt.yandex.net' % config['yt']['cluster_name'],
        token=config['yt']['token'],
    )


def get_yql(config):
    return YqlClient(token=config['ydb']['token'])
