# -*- coding: utf-8 -*-

from nile.aggregators.implementations.histogram import HistogramAggregator
from nile.aggregators.input_function import Field
from nile.aggregators.simple_description import SimpleAggregatorDescription
from nile.utils.hash import Hashable


class HistogramByListAggregator(HistogramAggregator):
    def add_input(self, input):
        if isinstance(input, list) or isinstance(input, tuple):
            for value in input:
                bucket = self._bucket_function(value)
                self._buckets[Hashable(bucket)] += 1
        else:
            bucket = self._bucket_function(input)
            self._buckets[Hashable(bucket)] += 1


def histogram_by_list(field, sorted=False):
    return SimpleAggregatorDescription(
        constructor=HistogramByListAggregator,
        input_function=Field(field),
        options={'sorted': sorted},
    )


def histogram_with_top(field, top_count=100):

    def top_output_function(values):
        values.sort(key=lambda x: x[1])
        return values[-top_count:]

    return SimpleAggregatorDescription(
        constructor=HistogramAggregator,
        input_function=Field(field),
        output_function=top_output_function,
    )
