from contextlib import contextmanager
from logging import (
    ERROR,
    INFO,
)
import sys


class LoggerWriter(object):
    def __init__(self, writer, level, prefix=''):
        self._writer = writer
        self._level = level
        self.prefix = prefix + ': ' if prefix else ''

    def write(self, message):
        self._writer.log(self._level, self.prefix + message.strip())

    def flush(self):
        pass


@contextmanager
def redirect_stdout_stderr_to_logger(logger):
    old_out_target, sys.stdout = sys.stdout, LoggerWriter(logger, INFO, 'STDOUT')  # replace sys.stdout
    old_err_target, sys.stderr = sys.stderr, LoggerWriter(logger, ERROR, 'STDERR')  # replace sys.stderr
    try:
        yield
    finally:
        sys.stdout = old_out_target
        sys.stderr = old_err_target
