# -*- coding: utf-8 -*-
from pandas_confusion import BinaryConfusionMatrix


def xfrange(start, stop, step):
    while start < stop:
        yield start
        start += step


def fnr_of_threshold(target, predicted, step=0.05):
    x = []
    y = []
    for bound in xfrange(0, 1.01, step):
        cm = BinaryConfusionMatrix(
            target,
            map(lambda x: int(x >= bound), predicted),
        )
        x.append(bound)
        y.append(cm.FNR)
    return x, y


def fpr_of_threshold(target, predicted, step=0.05):
    x = []
    y = []
    for bound in xfrange(0, 1.01, step):
        cm = BinaryConfusionMatrix(
            target,
            map(lambda x: int(x >= bound), predicted),
        )
        x.append(bound)
        y.append(cm.FPR)
    return x, y
