# -*- coding: utf-8 -*-
import pandas as pd

from .mathematics import sigmoid


def read_test_results(resultsfile):
    columns = (
        'query_id',
        'target',
        'url',
        'weight',
        'result',
    )

    df = pd.read_csv(resultsfile, sep='\t', header=None, names=columns)
    df['probability'] = df['result'].map(sigmoid)
    return df
