import os

import passport.backend.core.ydb_client as ydb
from ydb.public.api.protos import ydb_table_pb2


def get_session(config):
    connection_params = ydb.ConnectionParams(
        config['ydb']['endpoint'],
        database=config['ydb']['database'],
        auth_token=config['ydb']['token'],
    )
    driver = ydb.Driver(connection_params)
    driver.wait(timeout=5)
    return driver.table_client.session().create()


def create_profile_tables(config):
    session = get_session(config)
    session.create_table(
        os.path.join(config['ydb']['database'], config['ydb']['table_name']),
        ydb.TableDescription()
        .with_column(ydb.Column('uid', ydb.OptionalType(ydb.DataType.Uint64)))
        .with_column(ydb.Column('inverted_event_timestamp', ydb.OptionalType(ydb.DataType.Uint64)))
        .with_column(ydb.Column('unique_id', ydb.OptionalType(ydb.DataType.Uint64)))
        .with_column(ydb.Column('value', ydb.OptionalType(ydb.DataType.Json)))
        .with_column(ydb.Column('updated_at', ydb.OptionalType(ydb.DataType.Uint64)))
        .with_primary_keys('uid', 'inverted_event_timestamp', 'unique_id')
        .with_profile(
            ydb.TableProfile()
            .with_partitioning_policy(
                ydb.PartitioningPolicy()
                .with_uniform_partitions(64)
                .with_auto_partitioning(
                    ydb_table_pb2.PartitioningPolicy.AutoPartitioningPolicy.DESCRIPTOR.values_by_name['AUTO_SPLIT_MERGE'].number,
                )
            )
        )
    )


def drop_profile_tables(config):
    session = get_session(config)
    session.drop_table(os.path.join(config['ydb']['database'], config['ydb']['table_name']))
