# -*- coding: utf-8 -*-

import logging

from nile.monitors.ascii import ConsoleMonitor


log = logging.getLogger('passport.profile.progress')


class LoggerStream(object):
    def __init__(self, logger, level):
        self.logger = logger
        self.level = level

    def write(self, message):
        if message != '\n':
            self.logger.log(self.level, message)

    def isatty(self):
        return False

    def flush(self):
        pass


class LoggedMonitor(ConsoleMonitor):
    name = 'Logged'

    def __init__(self, stream):
        stream = stream or LoggerStream(log, logging.DEBUG)
        super(LoggedMonitor, self).__init__(stream=stream)
