PY2_LIBRARY()

OWNER(
    g:passport_python
)

PEERDIR(
    contrib/python/dateutil
    contrib/python/numpy
    contrib/python/pandas
    contrib/python/retrying
    library/python/yenv
    passport/backend/core/ydb_client
    passport/backend/core/utils
    passport/backend/library/configurator
    passport/backend/profile/configs
    statbox/qb2
    metrika/uatraits/python  # необходим для qb2
    statbox/nile
    yql/library/python
)

PY_SRCS(
    __init__.py
    aggregators.py
    extractors.py
    jobs/__init__.py
    jobs/blackbox_events.py
    jobs/calculate_auth_frequencies.py
    jobs/oauth_events.py
    jobs/passport_events.py
    jobs/passport_glogouts_events.py
    jobs/prepare_dataset_for_tensornet.py
    jobs/prepare_train_auth_dataset_by_time_batches.py
    scripts/__init__.py
    scripts/build_profile_daily.py
    scripts/build_robot_reg_stats.py
    scripts/build_train_dataset.py
    scripts/cleanup.py
    scripts/create_profile_tables.py
    scripts/delete_old_rows.py
    scripts/grep_user_auth.py
    scripts/prepare_dataset_for_tensornet.py
    scripts/split_dataset.py
    scripts/upload_profile_to_ydb.py
    utils/__init__.py
    utils/helpers.py
    utils/parsers.py
    utils/yt.py
)

END()

RECURSE(
    bin
    monitor
)

RECURSE_FOR_TESTS (
    test
    tests  # It is not autotest!
)
