""" Обёртка Historydb API """
from django.conf import settings
from passport.backend.core.builders.historydb_api import HistoryDBApi
from passport.backend.py_adm.core.tvm.tvm import get_tvmauth_credentials_manager


def get_historydb_api() -> HistoryDBApi:
    return HistoryDBApi(
        historydb_api=settings.HISTORYDB_API_URL,
        retries=settings.HISTORYDB_API_RETRIES,
        timeout=settings.HISTORYDB_API_TIMEOUT,
        use_tvm=settings.HISTORYDB_API_USE_TVM,
        consumer=settings.HISTORYDB_API_CONSUMER,
        tvm_credentials_manager=get_tvmauth_credentials_manager(),
    )
