import mock
from passport.backend.core.lazy_loader import LazyLoader
from passport.backend.core.test.test_utils import single_entrant_patch
from passport.backend.py_adm.core.tvm.tvm import TvmAuthCredentialsManager


@single_entrant_patch
class FakeTvmAuthCredentialsManager:
    _ticket_data: dict[str, str]

    def __init__(self):
        self._init_patch = mock.patch.object(
            TvmAuthCredentialsManager,
            '__init__',
            mock.Mock(return_value=None),
        )
        self._get_ticket_by_alias_patch = mock.patch.object(
            TvmAuthCredentialsManager,
            'get_ticket_by_alias',
            self._get_ticket_by_alias,
        )
        self._check_user_role_patch = mock.patch.object(
            TvmAuthCredentialsManager,
            'check_user_role',
            self._check_user_role,
        )
        self._ticket_data = dict()
        self._roles = set()

    def set_ticket_data(self, ticket_data: dict[str, str]):
        self._ticket_data = ticket_data

    def set_existing_roles(self, roles: set[str]):
        self._roles = roles

    def start(self):
        self._init_patch.start()
        self._get_ticket_by_alias_patch.start()
        self._check_user_role_patch.start()
        LazyLoader.flush(instance_name='TvmCredentialsManager')

    def stop(self):
        self._check_user_role_patch.stop()
        self._get_ticket_by_alias_patch.stop()
        self._init_patch.stop()

    def _get_ticket_by_alias(self, alias: str):
        return self._ticket_data[alias]

    def _check_user_role(self, yauser, uid, role):
        return role in self._roles
