# isort:skip_file
""" Gunicorn лаунчер """
import os

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'passport.backend.py_adm.settings.settings')

import psutil

import django
from django.core.wsgi import get_wsgi_application
from django.conf import settings
import yenv

from passport.backend.core.conf import settings as passport_settings
from passport.backend.library.wsgi_runner import Runner
from passport.backend.library.configurator import Configurator
from passport.backend.utils.warnings import enable_strict_bytes_mode


def prepare_environment():
    django.setup()
    if yenv.type != 'development' and 'insecure' in settings.SECRET_KEY:
        raise Exception('Please set SECRET_DJANGO_KEY env')
    enable_strict_bytes_mode()
    passport_settings.configure(settings)


def read_config():
    config = Configurator(
        'py_adm',
        configs=[
            'base.yaml',
            '%s.yaml' % yenv.type,
            'devserver.yaml' if settings.DEVSERVER else {},
            'gunicorn-custom.yaml?',
            # отсутствует в ресурсах, но может читаться с диска
        ],
    )

    workers = config.get('application', {}).get('workers')
    workers_by_threads = config.get('application', {}).get('workers_by_threads')
    if workers_by_threads and not workers:
        n_cpu = psutil.cpu_count(logical=True)
        workers = workers_by_threads.get(n_cpu, workers_by_threads['default'])
        config['application']['workers'] = workers

    return config


def main():
    prepare_environment()

    runner = Runner(
        get_wsgi_application(),
        config=read_config(),
    )
    runner.run()
