from django import forms
from django.core.exceptions import ValidationError


class PushHistoryForm(forms.Form):
    date_from = forms.DateTimeField(label='Date from')
    date_to = forms.DateTimeField(label='Date to')
    uid = forms.IntegerField(label='Uid', required=False)
    device_id = forms.CharField(label='Device id', required=False)
    app = forms.CharField(label='App', required=False)

    def clean(self):
        cleaned_data = super().clean()
        uid = cleaned_data.get('uid')
        device_id = cleaned_data.get('uid')
        if not (uid or device_id):
            raise ValidationError("Either Uid or Device id should be set")
        return cleaned_data


class PushForm(forms.Form):
    push_id = forms.CharField(label='Push id')
