"""py_adm URL Configuration
"""
from django.urls import (
    include,
    path,
    re_path,
)
from django.views.generic import RedirectView
from passport.backend.py_adm.py_adm.views import (
    robots_view,
    static_view,
    test_view,
)


urlpatterns = [
    path('', RedirectView.as_view(url='/push/history/', permanent=False)),
    path('test/', test_view, name='test'),
    path('robots.txt', robots_view),
    path('push/', include('passport.backend.py_adm.pushes.urls')),
    re_path(r'^static/(?P<path>.+)$', static_view),
]
