import mimetypes
from pathlib import Path

from __res import resfs_read
from django.conf import settings
from django.http import (
    HttpRequest,
    HttpResponse,
    HttpResponseNotFound,
)


def static_view(request: HttpRequest, path: str):
    if '..' in path:
        return HttpResponseNotFound('Not found')

    mime_type, _ = mimetypes.guess_type(path)

    res_dir = Path(settings.STATICFILES_VIEW_DIR)
    data = resfs_read(str(res_dir / path))
    if data is None:
        return HttpResponseNotFound('Not found')

    response = HttpResponse(data, content_type=mime_type)
    return response


def robots_view(request: HttpRequest):
    return HttpResponse(b'User-agent: *\nDisallow: /')


def test_view(request: HttpRequest):
    return HttpResponse(b'test')
