"""
Django system settings for py_adm project.
"""

from pathlib import Path

from .env import DEVELOPMENT


BASE_DIR = Path(__file__).resolve().parent.parent

INSTALLED_APPS = [
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'django_yauth',
    'passport.backend.py_adm.py_adm',
    'passport.backend.py_adm.pushes',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'django_yauth.middleware.YandexAuthMiddleware',
]

if DEVELOPMENT:
    AUTHENTICATION_BACKENDS = [
        'django_yauth.authentication_mechanisms.dev.UserFromCookieAuthBackend',
    ]
else:
    AUTHENTICATION_BACKENDS = [
        'django_yauth.authentication_mechanisms.cookie.Mechanism',
    ]

ROOT_URLCONF = 'passport.backend.py_adm.py_adm.urls'

TEMPLATES = [
    {
        'BACKEND': 'library.python.django.template.backends.arcadia.ArcadiaTemplates',
        'OPTIONS': {
            'debug': DEVELOPMENT,
            'loaders': [
                'library.python.django.template.loaders.resource.Loader',
                'library.python.django.template.loaders.app_resource.Loader',
            ],
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
                'django_yauth.context.yauth',
            ],
        },
    },
]
FORM_RENDERER = 'library.python.django.template.backends.forms_renderer.ArcadiaRenderer'

WSGI_APPLICATION = 'py_adm.wsgi.application'


DATABASES = {}

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'Europe/Moscow'

USE_I18N = True

USE_TZ = True


STATIC_URL = 'static/'
STATICFILES_FINDERS = [
    'library.python.django.contrib.staticfiles.finders.ResfsFinder',
    'library.python.django.contrib.staticfiles.finders.ArcadiaAppFinder',
]
STATICFILES_DIRS = [
    'passport/backend/py_adm/static',
]
STATICFILES_VIEW_DIR = STATICFILES_DIRS[0]


DEFAULT_AUTO_FIELD = 'django.db.models.BigAutoField'
