# -*- coding: utf-8 -*-
# isort:skip_file
import os

from .default import DJANGO_KEY, TVM_SECRET

secret_settings = None


def resolve_setting(name, default_value):
    return os.environ.get('SECRET_{}'.format(name), default_value)


SECRET_KEY = resolve_setting('DJANGO_KEY', DJANGO_KEY)
TVM_SECRET = resolve_setting('TVM_SECRET', TVM_SECRET)
