#!/usr/bin/env python3
# -*- coding: utf-8 -*-
import json
import sys


def main():
    raw_data = sys.stdin.read()
    if not input:
        return
    try:
        data = json.loads(raw_data)
        for key, value in data.items():
            print('export PASSPORT_AUTOTESTS_{key}="{value}"'.format(key=key.upper(), value=value))
    except json.decoder.JSONDecodeError as e:
        print('Failed to parse JSON from {}'.format(repr(raw_data)))
        sys.exit(1)


if __name__ == '__main__':
    main()
