# -*- coding: utf-8 -*-
from http.cookies import SimpleCookie
from typing import Optional

from dataclasses import dataclass
from passport.backend.qa.autotests.base.helpers.cookies import parse_cookies


@dataclass
class Account:
    cookies: Optional[str] = None
    token: Optional[str] = None
    firstname: Optional[str] = None
    lastname: Optional[str] = None
    login: Optional[str] = None
    password: Optional[str] = None
    uid: Optional[int] = None
    extra_data: Optional[dict] = None

    @property
    def parsed_cookies(self) -> SimpleCookie:
        return parse_cookies(self.cookies)
