from passport.backend.qa.autotests.base.account import Account
from passport.backend.qa.autotests.base.secrets import secrets
from passport.backend.qa.autotests.base.settings.env import ENV


def get_accounts_store():
    accounts_store = {}
    if ENV in ('development', 'testing'):
        accounts_store['user_with_bound_card'] = Account(
            uid=4087325585,
            login='yndx-passp-tests-bound-card',
            password=secrets.PASSWORD_YNDX_PASSP_TESTS_BOUND_CARD,
            extra_data={
                'card_id': 'card-x434db6f255a39636ffdf5c5c',
            },
        )
    elif ENV == 'intranet_testing':
        accounts_store['user'] = Account(
            uid=1100000000000450,
            login='passp-tests-user',
            password=secrets.PASSWORD_PASSP_TESTS_USER,
            extra_data={
                'long_password': secrets.LONG_PASSWORD_PASSP_TESTS_USER,
                'mdm_password': secrets.MDM_PASSWORD_PASSP_TESTS_USER,
            },
        )
        accounts_store['user_with_2fa'] = Account(
            uid=1100000000000451,
            login='passp-tests-2fa',
            password=secrets.PASSWORD_PASSP_TESTS_2FA,
        )
        accounts_store['user_with_password_change_required'] = Account(
            uid=1100000000000452,
            login='passp-tests-chpwd',
            password=secrets.PASSWORD_PASSP_TESTS_CHPWD,
        )
        accounts_store['robot'] = Account(
            uid=1100000000000453,
            login='passp-tests-robot',
            password=secrets.PASSWORD_PASSP_TESTS_ROBOT,
        )
    return accounts_store


def get_account(name):
    return get_accounts_store()[name]
