# -*- coding: utf-8 -*-
import inspect
import re

import allure


def _get_suite_name(cls):
    # Сделать просто cls.__module__ нельзя, так как из-за аркадийной специфики путь будет считаться от
    # последнего ya.make. Поэтому приходится исхитряться.
    return re.match(
        r'passport/backend/qa/autotests/(.*)\.py',
        inspect.getfile(cls),
    ).group(1).replace('/', '.')


def allure_setup(feature, story):
    def decorator(cls):
        for dec in (
            allure.label('suite', _get_suite_name(cls)),
            allure.label('parentSuite', _get_suite_name(cls).rsplit('.', 1)[0]),
            allure.feature(feature),
            allure.story(story),
        ):
            cls = dec(cls)
        return cls
    return decorator
