from passport.backend.core.builders.blackbox.url_builders import serialize_blackbox_attributes_to_url
from passport.backend.qa.autotests.base.builders.base import AutotestsJsonBuilder
from passport.backend.qa.autotests.base.settings.blackbox import (
    BLACKBOX_TVM_DST_ALIAS,
    BLACKBOX_URL,
)


class Blackbox(AutotestsJsonBuilder):
    def __init__(self):
        super(Blackbox, self).__init__(
            base_url=BLACKBOX_URL,
            tvm_dst_alias=BLACKBOX_TVM_DST_ALIAS,
            use_proxy=True,
        )

    def request(
        self,
        method,
        path,
        query_params=None,
        form_params=None,
        *args,
        **kwargs
    ):
        self._update_attributes_with_csv(form_params)
        self._update_attributes_with_csv(query_params)
        return super().request(
            method,
            path,
            query_params,
            form_params,
            *args,
            **kwargs
        )

    def _update_attributes_with_csv(self, params):
        if params is not None:
            attrs = params.get('attributes')
            if isinstance(attrs, list):
                attrs = serialize_blackbox_attributes_to_url(attrs)
                params['attributes'] = attrs
